/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action0;

public final class OperatorSubscribeOn<T>
implements Observable.OnSubscribe<T> {
    final Scheduler scheduler;
    final Observable<T> source;

    public OperatorSubscribeOn(Observable<T> source, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.source = source;
    }

    @Override
    public void call(final Subscriber<? super T> subscriber) {
        final Scheduler.Worker inner = this.scheduler.createWorker();
        subscriber.add(inner);
        inner.schedule(new Action0(){

            @Override
            public void call() {
                final Thread t = Thread.currentThread();
                Subscriber s = new Subscriber<T>(subscriber){

                    @Override
                    public void onNext(T t2) {
                        subscriber.onNext(t2);
                    }

                    @Override
                    public void onError(Throwable e) {
                        try {
                            subscriber.onError(e);
                        }
                        finally {
                            inner.unsubscribe();
                        }
                    }

                    @Override
                    public void onCompleted() {
                        try {
                            subscriber.onCompleted();
                        }
                        finally {
                            inner.unsubscribe();
                        }
                    }

                    @Override
                    public void setProducer(final Producer p) {
                        subscriber.setProducer(new Producer(){

                            @Override
                            public void request(final long n) {
                                if (t == Thread.currentThread()) {
                                    p.request(n);
                                } else {
                                    inner.schedule(new Action0(){

                                        @Override
                                        public void call() {
                                            p.request(n);
                                        }
                                    });
                                }
                            }
                        });
                    }
                };
                OperatorSubscribeOn.this.source.unsafeSubscribe(s);
            }
        });
    }
}

