/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.request.target;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.zoyi.com.bumptech.glide.request.animation.GlideAnimation;
import com.zoyi.com.bumptech.glide.request.target.ImageViewTarget;
import com.zoyi.com.bumptech.glide.request.target.SquaringDrawable;

public class GlideDrawableImageViewTarget
extends ImageViewTarget<GlideDrawable> {
    private static final float SQUARE_RATIO_MARGIN = 0.05f;
    private int maxLoopCount;
    private GlideDrawable resource;

    public GlideDrawableImageViewTarget(ImageView view) {
        this(view, -1);
    }

    public GlideDrawableImageViewTarget(ImageView view, int maxLoopCount) {
        super(view);
        this.maxLoopCount = maxLoopCount;
    }

    @Override
    public void onResourceReady(GlideDrawable resource, GlideAnimation<? super GlideDrawable> animation) {
        if (!resource.isAnimated()) {
            float viewRatio = (float)((ImageView)this.view).getWidth() / (float)((ImageView)this.view).getHeight();
            float drawableRatio = (float)resource.getIntrinsicWidth() / (float)resource.getIntrinsicHeight();
            if (Math.abs(viewRatio - 1.0f) <= 0.05f && Math.abs(drawableRatio - 1.0f) <= 0.05f) {
                resource = new SquaringDrawable(resource, ((ImageView)this.view).getWidth());
            }
        }
        super.onResourceReady(resource, animation);
        this.resource = resource;
        resource.setLoopCount(this.maxLoopCount);
        resource.start();
    }

    @Override
    protected void setResource(GlideDrawable resource) {
        ((ImageView)this.view).setImageDrawable((Drawable)resource);
    }

    @Override
    public void onStart() {
        if (this.resource != null) {
            this.resource.start();
        }
    }

    @Override
    public void onStop() {
        if (this.resource != null) {
            this.resource.stop();
        }
    }
}

