/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.data;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.zoyi.com.bumptech.glide.Priority;
import com.zoyi.com.bumptech.glide.load.data.DataFetcher;
import com.zoyi.com.bumptech.glide.load.data.ExifOrientationStream;
import com.zoyi.com.bumptech.glide.load.resource.bitmap.ImageHeaderParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MediaStoreThumbFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "MediaStoreThumbFetcher";
    private static final int MINI_WIDTH = 512;
    private static final int MINI_HEIGHT = 384;
    private static final ThumbnailStreamOpenerFactory DEFAULT_FACTORY = new ThumbnailStreamOpenerFactory();
    private final Context context;
    private final Uri mediaStoreUri;
    private final DataFetcher<InputStream> defaultFetcher;
    private final int width;
    private final int height;
    private final ThumbnailStreamOpenerFactory factory;
    private InputStream inputStream;

    public MediaStoreThumbFetcher(Context context, Uri mediaStoreUri, DataFetcher<InputStream> defaultFetcher, int width, int height) {
        this(context, mediaStoreUri, defaultFetcher, width, height, DEFAULT_FACTORY);
    }

    MediaStoreThumbFetcher(Context context, Uri mediaStoreUri, DataFetcher<InputStream> defaultFetcher, int width, int height, ThumbnailStreamOpenerFactory factory) {
        this.context = context;
        this.mediaStoreUri = mediaStoreUri;
        this.defaultFetcher = defaultFetcher;
        this.width = width;
        this.height = height;
        this.factory = factory;
    }

    @Override
    public InputStream loadData(Priority priority) throws Exception {
        ThumbnailStreamOpener fetcher = this.factory.build(this.mediaStoreUri, this.width, this.height);
        if (fetcher != null) {
            this.inputStream = this.openThumbInputStream(fetcher);
        }
        if (this.inputStream == null) {
            this.inputStream = this.defaultFetcher.loadData(priority);
        }
        return this.inputStream;
    }

    private InputStream openThumbInputStream(ThumbnailStreamOpener fetcher) {
        InputStream result;
        block4: {
            result = null;
            try {
                result = fetcher.open(this.context, this.mediaStoreUri);
            }
            catch (FileNotFoundException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                Log.d((String)TAG, (String)"Failed to find thumbnail file", (Throwable)e);
            }
        }
        int orientation = -1;
        if (result != null) {
            orientation = fetcher.getOrientation(this.context, this.mediaStoreUri);
        }
        if (orientation != -1) {
            result = new ExifOrientationStream(result, orientation);
        }
        return result;
    }

    @Override
    public void cleanup() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.defaultFetcher.cleanup();
    }

    @Override
    public String getId() {
        return this.mediaStoreUri.toString();
    }

    @Override
    public void cancel() {
    }

    private static boolean isMediaStoreUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme()) && "media".equals(uri.getAuthority());
    }

    private static boolean isMediaStoreVideo(Uri uri) {
        return MediaStoreThumbFetcher.isMediaStoreUri(uri) && uri.getPathSegments().contains("video");
    }

    static class ThumbnailStreamOpenerFactory {
        ThumbnailStreamOpenerFactory() {
        }

        public ThumbnailStreamOpener build(Uri uri, int width, int height) {
            if (!MediaStoreThumbFetcher.isMediaStoreUri(uri) || width > 512 || height > 384) {
                return null;
            }
            if (MediaStoreThumbFetcher.isMediaStoreVideo(uri)) {
                return new ThumbnailStreamOpener(new VideoThumbnailQuery());
            }
            return new ThumbnailStreamOpener(new ImageThumbnailQuery());
        }
    }

    static class VideoThumbnailQuery
    implements ThumbnailQuery {
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND video_id = ?";

        VideoThumbnailQuery() {
        }

        @Override
        public Cursor queryPath(Context context, Uri uri) {
            String videoId = uri.getLastPathSegment();
            return context.getContentResolver().query(MediaStore.Video.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{videoId}, null);
        }
    }

    static class ImageThumbnailQuery
    implements ThumbnailQuery {
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND image_id = ?";

        ImageThumbnailQuery() {
        }

        @Override
        public Cursor queryPath(Context context, Uri uri) {
            String imageId = uri.getLastPathSegment();
            return context.getContentResolver().query(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{imageId}, null);
        }
    }

    static class ThumbnailStreamOpener {
        private static final FileService DEFAULT_SERVICE = new FileService();
        private final FileService service;
        private ThumbnailQuery query;

        public ThumbnailStreamOpener(ThumbnailQuery query) {
            this(DEFAULT_SERVICE, query);
        }

        public ThumbnailStreamOpener(FileService service, ThumbnailQuery query) {
            this.service = service;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getOrientation(Context context, Uri uri) {
            int orientation = -1;
            InputStream is = null;
            try {
                is = context.getContentResolver().openInputStream(uri);
                orientation = new ImageHeaderParser(is).getOrientation();
            }
            catch (IOException e) {
                if (Log.isLoggable((String)MediaStoreThumbFetcher.TAG, (int)3)) {
                    Log.d((String)MediaStoreThumbFetcher.TAG, (String)("Failed to open uri: " + uri), (Throwable)e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return orientation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream open(Context context, Uri uri) throws FileNotFoundException {
            Uri thumbnailUri = null;
            InputStream inputStream = null;
            try (Cursor cursor = this.query.queryPath(context, uri);){
                if (cursor != null && cursor.moveToFirst()) {
                    thumbnailUri = this.parseThumbUri(cursor);
                }
            }
            if (thumbnailUri != null) {
                inputStream = context.getContentResolver().openInputStream(thumbnailUri);
            }
            return inputStream;
        }

        private Uri parseThumbUri(Cursor cursor) {
            File file;
            Uri result = null;
            String path = cursor.getString(0);
            if (!TextUtils.isEmpty((CharSequence)path) && this.service.exists(file = this.service.get(path)) && this.service.length(file) > 0L) {
                result = Uri.fromFile((File)file);
            }
            return result;
        }
    }

    static interface ThumbnailQuery {
        public Cursor queryPath(Context var1, Uri var2);
    }

    static class FileService {
        FileService() {
        }

        public boolean exists(File file) {
            return file.exists();
        }

        public long length(File file) {
            return file.length();
        }

        public File get(String path) {
            return new File(path);
        }
    }
}

