/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.source.userchat;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.base.SortedItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.ReferMessage;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserChatItem
implements SortedItem {
    private UserChatListDataDictionary dictionary;
    private UserChat userChat;
    private Session session;
    private ReferMessage message;
    private Set<String> profiles;

    public UserChatItem(UserChat userChat, UserChatListDataDictionary dictionary) {
        this.userChat = userChat;
        this.dictionary = dictionary;
        this.message = dictionary.get(ReferMessage.class, userChat.getLastMessageId());
        this.session = dictionary.get(Session.class, userChat.getSessionId());
        this.profiles = new HashSet<String>(userChat.getTalkedManagerIds());
    }

    public void setUserChat(UserChat userChat) {
        this.userChat = userChat;
        this.message = this.dictionary.get(ReferMessage.class, userChat.getLastMessageId());
        this.session = this.dictionary.get(Session.class, userChat.getSessionId());
        this.profiles = new HashSet<String>(userChat.getTalkedManagerIds());
    }

    public Long getUpdatedAt() {
        if (this.userChat != null) {
            return this.userChat.getUpdatedAt();
        }
        return 0L;
    }

    public String getId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return "";
    }

    public List<? extends ProfileEntity> getProfiles() {
        if (this.profiles == null || this.profiles.size() == 0) {
            return Collections.singletonList(ChannelStore.getChannel());
        }
        ArrayList<Manager> list = new ArrayList<Manager>();
        for (String id2 : this.profiles) {
            list.add(this.dictionary.get(Manager.class, id2));
        }
        return list;
    }

    public UserChat getUserChat() {
        return this.userChat;
    }

    public String getSessionId() {
        if (this.userChat != null) {
            return this.userChat.getSessionId();
        }
        return "";
    }

    public Session getSession() {
        return this.session;
    }

    public Message getMessage() {
        return this.message;
    }

    public boolean containsManager(String managerId) {
        return this.profiles != null && this.profiles.contains(managerId);
    }

    @Override
    public Long getFirst() {
        if (this.message != null) {
            return this.message.getCreatedAt();
        }
        return 0L;
    }

    @Override
    public String getSecond() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return "";
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

