/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.util;

import com.splunk.mint.network.util.DelegationException;
import com.splunk.mint.network.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Delegator {
    private final Object source;
    private final Object delegate;
    private final Class superclass;

    public Delegator(Object source, Class superclass, Object delegate) {
        this.source = source;
        this.superclass = superclass;
        this.delegate = delegate;
    }

    public Delegator(Object source, Class superclass, String delegateClassName) {
        try {
            this.source = source;
            this.superclass = superclass;
            Class<?> implCl = Class.forName(delegateClassName);
            Constructor<?> delegateConstructor = implCl.getDeclaredConstructor(new Class[0]);
            delegateConstructor.setAccessible(true);
            this.delegate = delegateConstructor.newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DelegationException("Could not make delegate object", e);
        }
    }

    public final <T> T invoke(Object ... args) throws Exception {
        String methodName = this.extractMethodName();
        Method method = this.findMethod(methodName, args);
        Object t = this.invoke0(method, args);
        return (T)t;
    }

    private Object invoke0(Method method, Object[] args) throws Exception {
        this.writeFields(this.superclass, this.source, this.delegate);
        method.setAccessible(true);
        Object result = method.invoke(this.delegate, args);
        this.writeFields(this.superclass, this.delegate, this.source);
        return result;
    }

    private void writeFields(Class clazz, Object from, Object to) throws Exception {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            field.set(to, field.get(from));
        }
    }

    private String extractMethodName() {
        Throwable t = new Throwable();
        String methodName = t.getStackTrace()[2].getMethodName();
        return methodName;
    }

    private Method findMethod(String methodName, Object[] args) throws NoSuchMethodException {
        Class clazz = this.superclass;
        if (args.length == 0) {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        Method match = null;
        block0: for (Method method : ReflectionUtil.getAllMethods(clazz)) {
            Class<?>[] classes;
            if (!method.getName().equals(methodName) || (classes = method.getParameterTypes()).length != args.length) continue;
            for (int i = 0; i < classes.length; ++i) {
                Class<?> argType = classes[i];
                if (!(argType = this.convertPrimitiveClass(argType)).isInstance(args[i])) continue block0;
            }
            if (match == null) {
                match = method;
                continue;
            }
            throw new DelegationException("Duplicate matches");
        }
        if (match != null) {
            return match;
        }
        throw new DelegationException("Could not find method: " + methodName);
    }

    private Class<?> convertPrimitiveClass(Class<?> primitive) {
        if (primitive.isPrimitive()) {
            if (primitive == Integer.TYPE) {
                return Integer.class;
            }
            if (primitive == Boolean.TYPE) {
                return Boolean.class;
            }
            if (primitive == Float.TYPE) {
                return Float.class;
            }
            if (primitive == Long.TYPE) {
                return Long.class;
            }
            if (primitive == Double.TYPE) {
                return Double.class;
            }
            if (primitive == Short.TYPE) {
                return Short.class;
            }
            if (primitive == Byte.TYPE) {
                return Byte.class;
            }
            if (primitive == Character.TYPE) {
                return Character.class;
            }
        }
        return primitive;
    }

    public DelegatorMethodFinder delegateTo(String methodName, Class<?> ... parameters) {
        return new DelegatorMethodFinder(methodName, parameters);
    }

    public class DelegatorMethodFinder {
        private final Method method;

        public DelegatorMethodFinder(String methodName, Class<?> ... parameterTypes) {
            try {
                this.method = Delegator.this.superclass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DelegationException(e);
            }
        }

        public <T> T invoke(Object ... parameters) throws Exception {
            Object t = Delegator.this.invoke0(this.method, parameters);
            return (T)t;
        }
    }
}

