/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal;

import android.util.Log;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.internal.OptionalMethod;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;

    public AndroidPlatform(Class<?> sslParametersClass, OptionalMethod<Socket> setUseSessionTickets, OptionalMethod<Socket> setHostname, OptionalMethod<Socket> getAlpnSelectedProtocol, OptionalMethod<Socket> setAlpnProtocols) {
        this.sslParametersClass = sslParametersClass;
        this.setUseSessionTickets = setUseSessionTickets;
        this.setHostname = setHostname;
        this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
        this.setAlpnProtocols = setAlpnProtocols;
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        try {
            socket.connect(address, connectTimeout);
        }
        catch (AssertionError e) {
            if (Util.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
        catch (SecurityException e) {
            IOException ioException = new IOException("Exception in connect");
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Override
    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        Object context = AndroidPlatform.readFieldOrNull(sslSocketFactory, this.sslParametersClass, "sslParameters");
        if (context == null) {
            try {
                Class<?> gmsSslParametersClass = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                context = AndroidPlatform.readFieldOrNull(sslSocketFactory, gmsSslParametersClass, "sslParameters");
            }
            catch (ClassNotFoundException e) {
                return super.trustManager(sslSocketFactory);
            }
        }
        if ((x509TrustManager = AndroidPlatform.readFieldOrNull(context, X509TrustManager.class, "x509TrustManager")) != null) {
            return x509TrustManager;
        }
        return AndroidPlatform.readFieldOrNull(context, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (hostname != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sslSocket, true);
            this.setHostname.invokeOptionalWithoutCheckedException(sslSocket, hostname);
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sslSocket)) {
            Object[] parameters = new Object[]{AndroidPlatform.concatLengthPrefixed(protocols)};
            this.setAlpnProtocols.invokeWithoutCheckedException(sslSocket, parameters);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported(socket)) {
            return null;
        }
        byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(socket, new Object[0]);
        return alpnResult != null ? new String(alpnResult, Util.UTF_8) : null;
    }

    @Override
    public void log(int level, String message, Throwable t) {
        int logLevel;
        int n = logLevel = level == 5 ? 5 : 3;
        if (t != null) {
            message = message + '\n' + Log.getStackTraceString((Throwable)t);
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                Log.println((int)logLevel, (String)"OkHttp", (String)message.substring(i, end));
            } while ((i = end) < newline);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted() {
        try {
            Class<?> networkPolicyClass = Class.forName("android.security.NetworkSecurityPolicy");
            Method getInstanceMethod = networkPolicyClass.getMethod("getInstance", new Class[0]);
            Object networkSecurityPolicy = getInstanceMethod.invoke(null, new Object[0]);
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", new Class[0]);
            boolean cleartextPermitted = (Boolean)isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, new Object[0]);
            return cleartextPermitted;
        }
        catch (ClassNotFoundException e) {
            return super.isCleartextTrafficPermitted();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError();
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> sslParametersClass;
            try {
                sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException e) {
                sslParametersClass = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> setUseSessionTickets = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> setHostname = new OptionalMethod<Socket>(null, "setHostname", String.class);
            OptionalMethod getAlpnSelectedProtocol = null;
            OptionalMethod setAlpnProtocols = null;
            try {
                Class.forName("android.net.Network");
                getAlpnSelectedProtocol = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                setAlpnProtocols = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new AndroidPlatform(sslParametersClass, setUseSessionTickets, setHostname, getAlpnSelectedProtocol, setAlpnProtocols);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

