/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.adapter.rxjava;

import com.zoyi.retrofit2.Call;
import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.Response;
import com.zoyi.retrofit2.adapter.rxjava.HttpException;
import com.zoyi.rx.Completable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.lang.reflect.Type;

final class CompletableHelper {
    CompletableHelper() {
    }

    static CallAdapter<Completable> createCallAdapter(Scheduler scheduler) {
        return new CompletableCallAdapter(scheduler);
    }

    static class CompletableCallAdapter
    implements CallAdapter<Completable> {
        private final Scheduler scheduler;

        CompletableCallAdapter(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        public Type responseType() {
            return Void.class;
        }

        public Completable adapt(Call call) {
            Completable completable = Completable.create((Completable.CompletableOnSubscribe)new CompletableCallOnSubscribe(call));
            if (this.scheduler != null) {
                return completable.subscribeOn(this.scheduler);
            }
            return completable;
        }
    }

    private static final class CompletableCallOnSubscribe
    implements Completable.CompletableOnSubscribe {
        private final Call originalCall;

        CompletableCallOnSubscribe(Call originalCall) {
            this.originalCall = originalCall;
        }

        public void call(Completable.CompletableSubscriber subscriber) {
            block5: {
                final Call call = this.originalCall.clone();
                Subscription subscription = Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        call.cancel();
                    }
                });
                subscriber.onSubscribe(subscription);
                try {
                    Response response = call.execute();
                    if (!subscription.isUnsubscribed()) {
                        if (response.isSuccessful()) {
                            subscriber.onCompleted();
                        } else {
                            subscriber.onError((Throwable)new HttpException(response));
                        }
                    }
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal((Throwable)t);
                    if (subscription.isUnsubscribed()) break block5;
                    subscriber.onError(t);
                }
            }
        }
    }
}

