/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class UserInfoMessageHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private Context context;
    private LinearLayout inputLayout;
    private LinearLayout completeLayout;
    private TextView title;
    private TextView errorTitle;
    private TextView description;
    private TextView agreement;
    private TextView country;
    private LinearLayout inputLayouts;
    private LinearLayout nameLayout;
    private LinearLayout phoneLayout;
    private LinearLayout countryLayout;
    private WatchedEditText nameEdit;
    private WatchedEditText phoneEdit;
    private Button nameButton;
    private Button phoneButton;
    private CountryDictionary countryDictionary;
    private OnUserInfoListener listener;
    private String code;
    private String mobileNumber;
    private boolean handle = false;

    public UserInfoMessageHolder(View itemView, final OnUserInfoListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.countryDictionary = new CountryDictionary(itemView.getContext());
        this.inputLayout = (LinearLayout)itemView.findViewById(R.id.layout_user_info_input);
        this.completeLayout = (LinearLayout)itemView.findViewById(R.id.layout_user_info_complete);
        this.title = (TextView)itemView.findViewById(R.id.user_info_title);
        this.errorTitle = (TextView)itemView.findViewById(R.id.user_info_error_title);
        this.description = (TextView)itemView.findViewById(R.id.user_info_description);
        this.agreement = (TextView)itemView.findViewById(R.id.user_info_agreement);
        this.inputLayouts = (LinearLayout)itemView.findViewById(R.id.user_info_layout);
        this.nameLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_name);
        this.phoneLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_phone);
        this.nameEdit = (WatchedEditText)itemView.findViewById(R.id.user_info_layout_name_input);
        this.nameButton = (Button)itemView.findViewById(R.id.user_info_layout_name_button);
        this.country = (TextView)itemView.findViewById(R.id.user_info_layout_phone_country);
        this.countryLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_phone_country_layout);
        this.phoneEdit = (WatchedEditText)itemView.findViewById(R.id.user_info_layout_phone_input);
        this.phoneButton = (Button)itemView.findViewById(R.id.user_info_layout_phone_button);
        int active = ContextCompat.getColor((Context)this.context, (int)R.color.ch_cobalt);
        int deactive = ContextCompat.getColor((Context)this.context, (int)R.color.ch_light);
        this.nameEdit.setHandledButton(this.nameButton, active, deactive);
        this.nameEdit.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String s) {
                if (listener != null && UserInfoMessageHolder.this.handle) {
                    listener.userInfoChanged(s);
                }
            }
        });
        this.phoneEdit.setHandledButton(this.phoneButton, active, deactive);
        this.phoneEdit.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String s) {
                if (listener != null && UserInfoMessageHolder.this.handle) {
                    listener.userInfoChanged(new MobileNumberItem(UserInfoMessageHolder.this.code, s));
                }
                UserInfoMessageHolder.this.mobileNumber = s;
            }
        });
        this.nameButton.setOnClickListener((View.OnClickListener)this);
        this.phoneButton.setOnClickListener((View.OnClickListener)this);
        this.countryLayout.setOnClickListener((View.OnClickListener)this);
        this.agreement.setText((CharSequence)Html.fromHtml((String)ResUtils.getString(this.context, "ch.agreement")));
        this.agreement.setOnClickListener((View.OnClickListener)this);
        this.code = "";
        this.mobileNumber = "";
        this.listener = listener;
    }

    private void initLayout(UserInfoItem item) {
        this.title.setVisibility(UIUtils.getVisible(!item.isError(), true));
        this.errorTitle.setVisibility(UIUtils.getVisible(item.isError(), true));
        this.inputLayout.setVisibility(UIUtils.getVisible(!UserInfoType.COMPLETE.equals((Object)item.getUserInfoType()), true));
        this.completeLayout.setVisibility(UIUtils.getVisible(UserInfoType.COMPLETE.equals((Object)item.getUserInfoType()), true));
        for (int i = 0; i < this.inputLayouts.getChildCount(); ++i) {
            this.inputLayouts.getChildAt(i).setVisibility(8);
        }
        switch (item.getUserInfoType()) {
            case NAME: {
                this.nameLayout.setVisibility(0);
                break;
            }
            case MOBILE_NUMBER: {
                this.phoneLayout.setVisibility(0);
            }
        }
    }

    private String getString(String string2) {
        return ResUtils.getString(this.context, string2);
    }

    public void set(UserInfoItem item) {
        this.initLayout(item);
        this.setAgreementVisibility();
        this.handle = true;
        switch (item.getUserInfoType()) {
            case NAME: {
                if (item.getObject() != null && item.getObject() instanceof String) {
                    String name = (String)item.getObject();
                    this.nameEdit.setText(name);
                }
                if (item.isError()) {
                    this.errorTitle.setText((CharSequence)this.getString("ch.name_verification.title"));
                    this.description.setText((CharSequence)this.getString("ch.name_verification.description"));
                    this.nameEdit.selectAll();
                    break;
                }
                this.title.setText((CharSequence)this.getString("ch.name_verification.title"));
                this.description.setText((CharSequence)this.getString("ch.name_verification.description"));
                break;
            }
            case MOBILE_NUMBER: {
                if (item.getObject() != null && item.getObject() instanceof MobileNumberItem) {
                    MobileNumberItem mobileNumberItem = (MobileNumberItem)item.getObject();
                    this.code = mobileNumberItem.getCountry();
                    this.mobileNumber = mobileNumberItem.getMobileNumber();
                    this.country.setText((CharSequence)String.format("+%s", mobileNumberItem.getCountry()));
                    this.phoneEdit.setText(mobileNumberItem.getMobileNumber());
                }
                if (item.isError()) {
                    this.errorTitle.setText((CharSequence)this.getString("ch.mobile_verification.error.title"));
                    this.description.setText((CharSequence)this.getString("ch.mobile_verification.error.description"));
                    this.phoneEdit.selectAll();
                    break;
                }
                this.title.setText((CharSequence)this.getString("ch.mobile_verification.title"));
                this.description.setText((CharSequence)this.getString("ch.mobile_verification.description"));
            }
        }
    }

    private void showCountryDialog() {
        ArrayAdapter adapter = new ArrayAdapter(this.context, 0x1090011);
        adapter.addAll(this.countryDictionary.getCountryNames());
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context).setCancelable(true).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                UserInfoMessageHolder.this.countrySelected(UserInfoMessageHolder.this.countryDictionary.getCode(which));
            }
        });
        try {
            builder.show();
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }

    private void countrySelected(String code) {
        this.country.setText((CharSequence)String.format("+%s", code));
        this.code = code;
        if (this.listener != null && this.handle) {
            this.listener.userInfoChanged(new MobileNumberItem(code, this.mobileNumber));
        }
    }

    private void setAgreementVisibility() {
        Channel channel = ChannelStore.getChannel();
        if (channel != null && channel.getCountry().equalsIgnoreCase("kr")) {
            this.agreement.setVisibility(0);
        } else {
            this.agreement.setVisibility(8);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.user_info_layout_phone_country_layout) {
            this.showCountryDialog();
        }
        if ((id2 == R.id.user_info_layout_name_button || id2 == R.id.user_info_layout_phone_button) && this.listener != null && this.handle) {
            this.listener.sendUserInfo();
        }
        if (id2 == R.id.user_info_agreement) {
            String url = "http://channel.io/ko/terms_user?channel=" + (ChannelStore.getChannel() != null ? ChannelStore.getChannel().getName() : "");
            Executor.goWeb(this.context, url);
        }
    }
}

