/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.OnChannelPluginChangedListener;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Script;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ChannelStore {
    private static ChannelStore channelStore;
    private Application application;
    private String pluginId;
    private Plugin plugin;
    private Channel channel;
    private User user;
    private Veil veil;
    private boolean mainRunning = false;
    private Subscription pluginFetchSubscription;
    private Subscription socketSubscription;
    private Map<String, Script> scriptMap;
    private ArrayList<OnChannelPluginChangedListener> listeners;

    static void create(Application application, String pluginId) {
        if (channelStore == null) {
            channelStore = new ChannelStore(application, pluginId);
        }
    }

    private ChannelStore(Application application, String pluginId) {
        this.application = application;
        this.pluginId = pluginId;
        this.listeners = new ArrayList();
    }

    static void checkIn(PluginWrapper pluginWrapper) {
        if (channelStore != null) {
            PrefSupervisor.setVeilId((Context)ChannelStore.channelStore.application, pluginWrapper.getVeilId());
            if (pluginWrapper.getUser() != null) {
                ChannelStore.channelStore.user = pluginWrapper.getUser();
            }
            ChannelStore.channelStore.plugin = pluginWrapper.getPlugin();
            ChannelStore.channelStore.channel = pluginWrapper.getChannel();
            ChannelStore.channelStore.veil = pluginWrapper.getVeil();
            channelStore.startReceiveSocket();
            channelStore.startFetchPlugin();
            channelStore.fetchScripts();
        }
    }

    static void clear() {
        if (channelStore != null) {
            channelStore.stopFetchPlugin();
            channelStore.stopReceiveSocket();
            ChannelStore.channelStore.plugin = null;
            ChannelStore.channelStore.channel = null;
            ChannelStore.channelStore.user = null;
            ChannelStore.channelStore.veil = null;
        }
    }

    private void startReceiveSocket() {
        if (this.socketSubscription == null || this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

                public void call(Object o) {
                    if (o instanceof CommandBus) {
                        CommandBus commandBus = (CommandBus)o;
                        switch (commandBus.getCommand()) {
                            case READY: {
                                ChannelStore.this.fetchMe();
                            }
                        }
                    }
                    if (o instanceof BadgeBus) {
                        for (OnChannelPluginChangedListener listener : ChannelStore.this.listeners) {
                            if (listener == null) continue;
                            listener.badgeChanged(((BadgeBus)o).getCount());
                        }
                    }
                }
            });
        }
    }

    private void stopReceiveSocket() {
        if (this.socketSubscription != null && !this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription.unsubscribe();
            this.socketSubscription = null;
        }
    }

    private void fetchMe() {
        ChannelPlugin.getApi().getMe().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<GuestWrapper>(){

            @Override
            public void onNext(GuestWrapper guestWrapper) {
                if (guestWrapper != null) {
                    ChannelStore.setUserVeil(guestWrapper.getUser(), guestWrapper.getVeil());
                }
            }
        });
    }

    private void startFetchPlugin() {
        this.stopFetchPlugin();
        this.pluginFetchSubscription = Observable.interval((long)3L, (TimeUnit)TimeUnit.MINUTES).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                if (channelStore != null) {
                    channelStore.fetchPlugin();
                }
            }
        });
    }

    private void stopFetchPlugin() {
        if (this.pluginFetchSubscription != null && !this.pluginFetchSubscription.isUnsubscribed()) {
            this.pluginFetchSubscription.unsubscribe();
            this.pluginFetchSubscription = null;
        }
    }

    private void fetchPlugin() {
        if (this.pluginId != null) {
            ChannelPlugin.getApi().getPlugin(this.pluginId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

                @Override
                public void onNext(PluginWrapper pluginWrapper) {
                    if (pluginWrapper != null) {
                        ChannelStore.this.plugin = pluginWrapper.getPlugin();
                        ChannelStore.this.channel = pluginWrapper.getChannel();
                    }
                }
            });
        }
    }

    private void fetchScripts() {
        ChannelPlugin.getApi().getScripts().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<ScriptsWrapper>(){

            @Override
            public void onNext(ScriptsWrapper scriptsWrapper) {
                ChannelStore.this.setScripts(scriptsWrapper.getScripts());
            }
        });
    }

    private void setScripts(List<Script> scripts) {
        if (this.scriptMap == null) {
            this.scriptMap = new HashMap<String, Script>();
        }
        if (scripts != null) {
            for (Script script : scripts) {
                if (script.getKey() == null || script.getMessage() == null) continue;
                this.scriptMap.put(script.getKey(), script);
            }
        }
    }

    public static String getScript(String key, String defaultResourceKey) {
        if (channelStore != null) {
            if (ChannelStore.channelStore.scriptMap != null && ChannelStore.channelStore.scriptMap.containsKey(key)) {
                String locale = Locale.getDefault().getLanguage();
                if (ChannelStore.channelStore.scriptMap.get(key).getMessage(locale) != null) {
                    return ChannelStore.channelStore.scriptMap.get(key).getMessage(locale);
                }
            }
            if (ChannelStore.channelStore.application != null) {
                return ResUtils.getString((Context)ChannelStore.channelStore.application, defaultResourceKey);
            }
        }
        return "";
    }

    public static Channel getChannel() {
        return channelStore != null ? ChannelStore.channelStore.channel : null;
    }

    public static User getUser() {
        return channelStore != null ? ChannelStore.channelStore.user : null;
    }

    public static String getName() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null && !ChannelStore.channelStore.user.isGhost().booleanValue()) {
                return ChannelStore.channelStore.user.getName();
            }
            if (ChannelStore.channelStore.veil != null && !ChannelStore.channelStore.veil.isGhost()) {
                return ChannelStore.channelStore.veil.getName();
            }
        }
        return null;
    }

    public static String getMobileNumber() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getMobileNumber();
            }
            if (ChannelStore.channelStore.veil != null) {
                return ChannelStore.channelStore.veil.getMobileNumber();
            }
        }
        return null;
    }

    public static String getPersonType() {
        if (channelStore != null && ChannelStore.channelStore.user != null) {
            return "User";
        }
        return "Veil";
    }

    public static String getPersonId() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getId();
            }
            return PrefSupervisor.getVeilId((Context)ChannelStore.channelStore.application);
        }
        return null;
    }

    public static String getVeilId() {
        if (channelStore != null && ChannelStore.channelStore.application != null) {
            return PrefSupervisor.getVeilId((Context)ChannelStore.channelStore.application);
        }
        return null;
    }

    public static String getUserId() {
        if (channelStore != null && ChannelStore.channelStore.user != null) {
            return ChannelStore.channelStore.user.getId();
        }
        return null;
    }

    public static boolean isWorking() {
        return channelStore != null && ChannelStore.channelStore.channel != null && ChannelStore.channelStore.channel.isWorking();
    }

    public static boolean hasName() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.isGhost() == false;
            }
            if (ChannelStore.channelStore.veil != null) {
                return !ChannelStore.channelStore.veil.isGhost();
            }
        }
        return true;
    }

    public static void setUserVeil(User user, Veil veil) {
        if (channelStore != null) {
            if (user != null) {
                ChannelStore.channelStore.user = user;
            }
            if (veil != null) {
                ChannelStore.channelStore.veil = veil;
            }
            RxBus.post(new BadgeBus(ChannelStore.getCount()));
        }
    }

    public static Plugin getPlugin() {
        if (channelStore != null) {
            return ChannelStore.channelStore.plugin;
        }
        return null;
    }

    public static String getPluginId() {
        if (channelStore != null) {
            return ChannelStore.channelStore.pluginId;
        }
        return null;
    }

    static void setMainRunning(boolean flag) {
        if (channelStore != null) {
            ChannelStore.channelStore.mainRunning = flag;
        }
    }

    public static boolean isMainRunning() {
        return channelStore != null && ChannelStore.channelStore.mainRunning;
    }

    static boolean isDataStored() {
        return channelStore != null && ChannelStore.channelStore.channel != null && ChannelStore.channelStore.plugin != null;
    }

    static int getCount() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getAlert();
            }
            if (ChannelStore.channelStore.veil != null) {
                return ChannelStore.channelStore.veil.getAlert();
            }
        }
        return 0;
    }

    static void addOnChannelPluginChangedListener(OnChannelPluginChangedListener listener) {
        if (channelStore != null && ChannelStore.channelStore.listeners != null) {
            ChannelStore.channelStore.listeners.add(listener);
        }
    }

    static void removeOnChannelPluginChangedListener(OnChannelPluginChangedListener listener) {
        if (channelStore != null && ChannelStore.channelStore.listeners != null) {
            ChannelStore.channelStore.listeners.remove(listener);
        }
    }
}

