/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action0;
import java.util.concurrent.TimeUnit;

public final class OnSubscribeTimerPeriodically
implements Observable.OnSubscribe<Long> {
    final long initialDelay;
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OnSubscribeTimerPeriodically(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void call(final Subscriber<? super Long> child) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        worker.schedulePeriodically(new Action0(){
            long counter;

            @Override
            public void call() {
                try {
                    child.onNext(this.counter++);
                }
                catch (Throwable e) {
                    try {
                        worker.unsubscribe();
                    }
                    finally {
                        Exceptions.throwOrReport(e, child);
                    }
                }
            }
        }, this.initialDelay, this.period, this.unit);
    }
}

