/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.L;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Executor {
    private static String photoPath = null;

    public static void takePhoto(Activity activity) {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        takePictureIntent.putExtra("output", (Parcelable)ChannelFileProvider.getUriForFile((Context)activity, Executor.getPhotoFile()));
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            activity.startActivityForResult(takePictureIntent, 3000);
        }
    }

    public static void startFileMediaScan(Activity activity, String filePath) {
        Executor.startFileMediaScan(activity, new File(filePath));
    }

    public static void startFileMediaScan(Activity activity, File file) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(Uri.fromFile((File)file));
        activity.sendBroadcast(mediaScanIntent);
    }

    public static String getPhotoPath() {
        return photoPath;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static File getPhotoFile() {
        File file = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            file = File.createTempFile(timeStamp, ".jpg", FileUtils.getPhotoDirectory());
            photoPath = file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void goWeb(Context context, String url) {
        Intent intent = new Intent("android.intent.action.VIEW");
        try {
            Uri uri = Uri.parse((String)url);
            if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
                uri = Uri.parse((String)("http://" + url));
            }
            intent.setData(uri);
            if (context != null) {
                context.startActivity(intent);
            }
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }
}

