package com.zoyi.channel.plugin.android.util;

import android.util.Log;
import com.zoyi.channel.plugin.android.ChannelPlugin;

/**
 * Created by mika on 2016. 1. 20..
 */
public class L {
  public static String TAG = "ChannelPlugin";

  private enum Type {
    Debug, Warning, Error, Info, Verbose
  }

  private static void write(Type type, String message) {
    if (message == null || message.equals("")) { return; }
    int level = 4;

    String fullClassName = Thread.currentThread().getStackTrace()[level].getClassName();
    String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1).split("$")[0];
    String methodName = Thread.currentThread().getStackTrace()[level].getMethodName();
    int lineNumber = Thread.currentThread().getStackTrace()[level].getLineNumber();

    String tag = String.format("%s %s.%s(%d):", TAG, className, methodName, lineNumber);

    switch (type) {
      case Debug:
        Log.d(tag, message);
        break;
      case Warning:
        Log.w(tag, message);
        break;
      case Error:
        Log.e(tag, message);
        break;
      case Info:
        Log.i(tag, message);
        break;
      case Verbose:
        Log.v(tag, message);
        break;
    }
  }

  public static void w(String message) { write(Type.Warning, message); }
  public static void e(String message) { write(Type.Error, message); }
  public static void i(String message) {
    if (!ChannelPlugin.isDebugMode()) { return; }
    write(Type.Info, message);
  }
  public static void d(String message) {
    if (!ChannelPlugin.isDebugMode()) { return; }
    write(Type.Debug, message);
  }
  public static void v(String message) {
    if (!ChannelPlugin.isDebugMode()) { return; }
    write(Type.Verbose, message);
  }

  public static void track(String trackId, String message) {
    write(Type.Info, String.format("Track:%s %s", trackId, message));
  }
}
