/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.BigBar$1;
import com.zoyi.channel.plugin.android.view.layout.BigBar$2;
import com.zoyi.channel.plugin.android.view.layout.BigBar$3;
import com.zoyi.channel.plugin.android.view.layout.BigBar$ButtonTouchHandler;
import com.zoyi.channel.plugin.android.view.layout.BigBar$MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$MenuState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigBar
extends LinearLayout {
    RelativeLayout root;
    RelativeLayout layout;
    LinearLayout leftLayout;
    LinearLayout rightLayout;
    TextView textTitle;
    RelativeLayout titleLayout;
    FrameLayout layoutAlert;
    TextView textAlert;
    private Context context;
    private BaseActivity activity;
    private Animation pushAnimation;
    private Animation alertAnimation;
    private int left;
    private int right;
    private boolean titleSelectable = false;
    private Map<Integer, TextView> textMap;
    private List<MenuButton> buttons;
    private int background = -16777216;
    private int foreground = -1;
    private boolean init = false;

    public BigBar(Context context) {
        super(context);
        this.init(context);
    }

    public BigBar(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public BigBar(Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context);
    }

    @TargetApi(value=21)
    public BigBar(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_bigbar, (ViewGroup)this, true);
        this.root = (RelativeLayout)this.findViewById(R.id.layout_root);
        this.layout = (RelativeLayout)this.findViewById(R.id.bar_layout);
        this.leftLayout = (LinearLayout)this.findViewById(R.id.layout_left);
        this.rightLayout = (LinearLayout)this.findViewById(R.id.layout_right);
        this.textTitle = (TextView)this.findViewById(R.id.bar_title_main);
        this.titleLayout = (RelativeLayout)this.findViewById(R.id.layout_title);
        this.textMap = new HashMap<Integer, TextView>();
        this.buttons = new ArrayList<MenuButton>();
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_push);
        this.pushAnimation.setAnimationListener((Animation.AnimationListener)new BigBar$1(this));
        this.alertAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_alert);
        this.alertAnimation.setFillEnabled(true);
        this.alertAnimation.setAnimationListener((Animation.AnimationListener)new BigBar$2(this));
    }

    public BigBar withActivity(BaseActivity baseActivity) {
        this.activity = baseActivity;
        return this;
    }

    public BigBar addMenu(MenuButton$ActionType menuButton$ActionType, BigBar$MenuPosition bigBar$MenuPosition) {
        return this.addMenu(menuButton$ActionType, bigBar$MenuPosition, MenuButton$MenuState.VISIBLE);
    }

    public BigBar addMenu(MenuButton$ActionType menuButton$ActionType, BigBar$MenuPosition bigBar$MenuPosition, MenuButton$MenuState menuButton$MenuState) {
        MenuButton menuButton = new MenuButton(this.context);
        menuButton.setAction(menuButton$ActionType);
        menuButton.setOnTouchListener(new BigBar$ButtonTouchHandler(this, (View)menuButton));
        menuButton.setOnClickListener(new BigBar$3(this, menuButton$ActionType));
        this.setViewState((View)menuButton, menuButton$MenuState);
        this.addView((View)menuButton, bigBar$MenuPosition, 40);
        this.buttons.add(menuButton);
        return this;
    }

    public BigBar addText(BigBar$MenuPosition bigBar$MenuPosition) {
        return this.addText(0, bigBar$MenuPosition, "");
    }

    public BigBar addText(BigBar$MenuPosition bigBar$MenuPosition, String string2) {
        return this.addText(0, bigBar$MenuPosition, string2);
    }

    private BigBar addText(int n2, BigBar$MenuPosition bigBar$MenuPosition, String string2) {
        if (!this.textMap.containsKey(n2)) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams((int)Utils.dpToPx(this.context, 32.0f), -2);
            new LinearLayout.LayoutParams((int)Utils.dpToPx(this.context, 32.0f), -2).weight = 1.0f;
            layoutParams.leftMargin = BigBar$MenuPosition.LEFT.equals((Object)bigBar$MenuPosition) ? -((int)Utils.dpToPx(this.context, 8.0f)) : 0;
            layoutParams.rightMargin = BigBar$MenuPosition.RIGHT.equals((Object)bigBar$MenuPosition) ? -((int)Utils.dpToPx(this.context, 8.0f)) : 0;
            layoutParams.gravity = 0x10 | (BigBar$MenuPosition.LEFT.equals((Object)bigBar$MenuPosition) ? 0x800003 : 0x800005);
            TextView textView = new TextView(this.context);
            textView.setTypeface(textView.getTypeface(), 1);
            textView.setTextSize(2, 14.0f);
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setText((CharSequence)string2);
            this.textMap.put(n2, textView);
            this.addView((View)textView, bigBar$MenuPosition, 32);
        }
        return this;
    }

    public void setText(int n2) {
        if (this.textMap.size() == 1) {
            this.setText(this.textMap.entrySet().iterator().next().getKey(), n2);
        }
    }

    public void setText(int n2, int n3) {
        if (this.textMap.containsKey(n2)) {
            this.textMap.get(n2).setText((CharSequence)Utils.getCount(n3, true));
        }
    }

    public void setMenuState(MenuButton$ActionType menuButton$ActionType, MenuButton$MenuState menuButton$MenuState) {
        if (menuButton$ActionType == null) {
            return;
        }
        for (MenuButton menuButton : this.buttons) {
            if (!menuButton$ActionType.equals((Object)menuButton.getAction())) continue;
            this.setViewState((View)menuButton, menuButton$MenuState);
        }
    }

    public BigBar setTitle(String string2) {
        this.textTitle.setText((CharSequence)string2);
        return this;
    }

    public BigBar setTheme(int n2, int n3) {
        this.background = n2;
        this.foreground = n3;
        this.layout.setBackgroundColor(n2);
        this.textTitle.setTextColor(n3);
        for (TextView object : this.textMap.values()) {
            object.setTextColor(n3);
        }
        for (MenuButton menuButton : this.buttons) {
            menuButton.setColor(n3);
        }
        return this;
    }

    public BigBar setTitleSelectable() {
        this.textTitle.setPadding(0, 0, (int)Utils.dpToPx(this.context, 24.0f), 0);
        this.titleSelectable = true;
        this.titleLayout.setOnTouchListener((View.OnTouchListener)new BigBar$ButtonTouchHandler(this, (View)this.titleLayout));
        return this;
    }

    public boolean isTitleSelectable() {
        return this.titleSelectable;
    }

    public void hide() {
        this.layout.setVisibility(8);
    }

    public void build() {
        if (this.init) {
            return;
        }
        this.init = true;
        if ((this.foreground < 0 || this.background < 0) && this.activity != null) {
            this.background = this.activity.getBackgroundColor();
            this.foreground = this.activity.getTextColor();
        }
        this.setTheme(this.background, this.foreground);
        int n2 = (int)Math.max(Utils.dpToPx(this.context, this.left + 16), Utils.dpToPx(this.context, this.right + 16));
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.titleLayout.getLayoutParams();
        ((RelativeLayout.LayoutParams)this.titleLayout.getLayoutParams()).leftMargin = n2;
        layoutParams.rightMargin = n2;
        this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setViewState(View view, MenuButton$MenuState menuButton$MenuState) {
        if (menuButton$MenuState == null) {
            return;
        }
        switch (menuButton$MenuState) {
            case VISIBLE: {
                view.setVisibility(0);
                view.setAlpha(1.0f);
                view.setEnabled(true);
                return;
            }
            case DISABLED: {
                view.setVisibility(0);
                view.setAlpha(0.3f);
                view.setEnabled(false);
                return;
            }
            case HIDDEN: {
                view.setVisibility(8);
            }
        }
    }

    private void addView(View view, BigBar$MenuPosition bigBar$MenuPosition, int n2) {
        if (BigBar$MenuPosition.LEFT.equals((Object)bigBar$MenuPosition)) {
            this.leftLayout.addView(view);
            this.left += n2;
            return;
        }
        this.rightLayout.addView(view);
        this.right += n2;
    }

    private void eventRaised(MenuButton$ActionType menuButton$ActionType) {
        if (this.activity != null) {
            this.activity.optionClicked(menuButton$ActionType);
        }
    }

    public void showAlert(String string2) {
        if (string2 != null) {
            this.textAlert.setText((CharSequence)string2);
            this.layoutAlert.startAnimation(this.alertAnimation);
        }
    }

    public void hideAlert() {
        this.layoutAlert.clearAnimation();
        this.layoutAlert.setVisibility(8);
    }

    static /* synthetic */ void access$000(BigBar bigBar, MenuButton$ActionType menuButton$ActionType) {
        bigBar.eventRaised(menuButton$ActionType);
    }
}

