/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.smooth_checkbox;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.Checkable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.CompatUtils;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$1;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$2;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$3;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$4;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$5;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$6;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$7;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox$OnCheckedChangeListener;

public class SmoothCheckBox
extends View
implements Checkable {
    private static final String KEY_INSTANCE_STATE = "InstanceState";
    private static final int COLOR_TICK = -1;
    private static final int COLOR_UNCHECKED = -1;
    private static final int COLOR_CHECKED = Color.parseColor((String)"#FB4846");
    private static final int COLOR_FLOOR_UNCHECKED = Color.parseColor((String)"#DFDFDF");
    private static final int DEF_DRAW_SIZE = 25;
    private static final int DEF_ANIM_DURATION = 300;
    private static final float DEF_TICK_SPEED = 20.0f;
    private Paint mPaint;
    private Paint mTickPaint;
    private Paint mFloorPaint;
    private Point[] mTickPoints;
    private Point mCenterPoint;
    private Path mTickPath;
    private float mLeftLineDistance;
    private float mRightLineDistance;
    private float mDrewDistance;
    private float mScaleVal = 1.0f;
    private float mFloorScale = 1.0f;
    private float mTickSpeed;
    private int mWidth;
    private int mAnimDuration;
    private int mStrokeWidth;
    private int mCheckedColor;
    private int mUnCheckedColor;
    private int mFloorColor;
    private int mFloorUnCheckedColor;
    private boolean mChecked;
    private boolean mTickDrawing;
    private SmoothCheckBox$OnCheckedChangeListener mListener;

    public SmoothCheckBox(Context context) {
        this(context, null);
    }

    public SmoothCheckBox(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SmoothCheckBox(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(attributeSet);
    }

    @TargetApi(value=21)
    public SmoothCheckBox(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.init(attributeSet);
    }

    private void init(AttributeSet attributeSet) {
        attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.SmoothCheckBox);
        int n2 = attributeSet.getColor(R.styleable.SmoothCheckBox_ch_color_tick, -1);
        this.mAnimDuration = attributeSet.getInt(R.styleable.SmoothCheckBox_ch_duration, 300);
        this.mTickSpeed = attributeSet.getFloat(R.styleable.SmoothCheckBox_ch_tick_speed, 20.0f);
        this.mFloorColor = attributeSet.getColor(R.styleable.SmoothCheckBox_ch_color_unchecked_stroke, COLOR_FLOOR_UNCHECKED);
        this.mCheckedColor = attributeSet.getColor(R.styleable.SmoothCheckBox_ch_color_checked, COLOR_CHECKED);
        this.mUnCheckedColor = attributeSet.getColor(R.styleable.SmoothCheckBox_ch_color_unchecked, -1);
        this.mStrokeWidth = attributeSet.getDimensionPixelSize(R.styleable.SmoothCheckBox_ch_stroke_width, CompatUtils.dp2px(this.getContext(), 0.0f));
        attributeSet.recycle();
        this.mFloorUnCheckedColor = this.mFloorColor;
        this.mTickPaint = new Paint(1);
        this.mTickPaint.setStyle(Paint.Style.STROKE);
        this.mTickPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mTickPaint.setColor(n2);
        this.mFloorPaint = new Paint(1);
        this.mFloorPaint.setStyle(Paint.Style.STROKE);
        this.mFloorPaint.setColor(this.mFloorColor);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mCheckedColor);
        this.mTickPath = new Path();
        this.mCenterPoint = new Point();
        this.mTickPoints = new Point[3];
        this.mTickPoints[0] = new Point();
        this.mTickPoints[1] = new Point();
        this.mTickPoints[2] = new Point();
        this.setOnClickListener(new SmoothCheckBox$1(this));
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putBoolean(KEY_INSTANCE_STATE, this.isChecked());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            parcelable = (Bundle)parcelable;
            boolean bl = parcelable.getBoolean(KEY_INSTANCE_STATE);
            this.setChecked(bl);
            super.onRestoreInstanceState(parcelable.getParcelable(KEY_INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(parcelable);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setChecked(boolean bl) {
        this.mChecked = bl;
        this.reset();
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onCheckedChanged(this, this.mChecked);
        }
    }

    public void setChecked(boolean bl, boolean bl2) {
        if (bl2) {
            this.mTickDrawing = false;
            this.mChecked = bl;
            this.mDrewDistance = 0.0f;
            if (bl) {
                this.startCheckedAnimation();
            } else {
                this.startUnCheckedAnimation();
            }
            if (this.mListener != null) {
                this.mListener.onCheckedChanged(this, this.mChecked);
                return;
            }
        } else {
            this.setChecked(bl);
        }
    }

    private void reset() {
        this.mTickDrawing = true;
        this.mFloorScale = 1.0f;
        this.mScaleVal = this.isChecked() ? 0.0f : 1.0f;
        this.mFloorColor = this.isChecked() ? this.mCheckedColor : this.mFloorUnCheckedColor;
        this.mDrewDistance = this.isChecked() ? this.mLeftLineDistance + this.mRightLineDistance : 0.0f;
    }

    private int measureSize(int n2) {
        int n3 = CompatUtils.dp2px(this.getContext(), 25.0f);
        int n4 = View.MeasureSpec.getSize((int)n2);
        n2 = View.MeasureSpec.getMode((int)n2);
        int n5 = 0;
        switch (n2) {
            case -2147483648: 
            case 0: {
                n5 = Math.min(n3, n4);
                break;
            }
            case 0x40000000: {
                n5 = n4;
            }
        }
        return n5;
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        this.setMeasuredDimension(this.measureSize(n2), this.measureSize(n3));
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.mWidth = this.getMeasuredWidth();
        this.mStrokeWidth = this.mStrokeWidth == 0 ? this.getMeasuredWidth() / 10 : this.mStrokeWidth;
        this.mStrokeWidth = this.mStrokeWidth > this.getMeasuredWidth() / 5 ? this.getMeasuredWidth() / 5 : this.mStrokeWidth;
        this.mStrokeWidth = this.mStrokeWidth < 3 ? 3 : this.mStrokeWidth;
        this.mCenterPoint.x = this.mWidth / 2;
        this.mCenterPoint.y = this.getMeasuredHeight() / 2;
        this.mTickPoints[0].x = Math.round((float)this.getMeasuredWidth() / 30.0f * 7.0f);
        this.mTickPoints[0].y = Math.round((float)this.getMeasuredHeight() / 30.0f * 14.0f);
        this.mTickPoints[1].x = Math.round((float)this.getMeasuredWidth() / 30.0f * 13.0f);
        this.mTickPoints[1].y = Math.round((float)this.getMeasuredHeight() / 30.0f * 20.0f);
        this.mTickPoints[2].x = Math.round((float)this.getMeasuredWidth() / 30.0f * 22.0f);
        this.mTickPoints[2].y = Math.round((float)this.getMeasuredHeight() / 30.0f * 10.0f);
        this.mLeftLineDistance = (float)Math.sqrt(Math.pow(this.mTickPoints[1].x - this.mTickPoints[0].x, 2.0) + Math.pow(this.mTickPoints[1].y - this.mTickPoints[0].y, 2.0));
        this.mRightLineDistance = (float)Math.sqrt(Math.pow(this.mTickPoints[2].x - this.mTickPoints[1].x, 2.0) + Math.pow(this.mTickPoints[2].y - this.mTickPoints[1].y, 2.0));
        this.mTickPaint.setStrokeWidth((float)this.mStrokeWidth);
    }

    protected void onDraw(Canvas canvas) {
        this.drawBorder(canvas);
        this.drawCenter(canvas);
        this.drawTick(canvas);
    }

    private void drawCenter(Canvas canvas) {
        this.mPaint.setColor(this.mUnCheckedColor);
        float f2 = (float)(this.mCenterPoint.x - this.mStrokeWidth) * this.mScaleVal;
        canvas.drawCircle((float)this.mCenterPoint.x, (float)this.mCenterPoint.y, f2, this.mPaint);
    }

    private void drawBorder(Canvas canvas) {
        float f2 = (float)this.mCenterPoint.x * this.mFloorScale - (float)(this.mCenterPoint.x - this.mStrokeWidth) * this.mScaleVal;
        float f3 = (float)this.mCenterPoint.x * this.mFloorScale - f2 / 2.0f;
        this.mFloorPaint.setColor(this.mFloorColor);
        this.mFloorPaint.setStrokeWidth(f2);
        this.mFloorPaint.setStyle(this.isChecked() ? Paint.Style.FILL_AND_STROKE : Paint.Style.STROKE);
        canvas.drawCircle((float)this.mCenterPoint.x, (float)this.mCenterPoint.y, f3, this.mFloorPaint);
    }

    private void drawTick(Canvas canvas) {
        if (this.mTickDrawing && this.isChecked()) {
            this.drawTickPath(canvas);
        }
    }

    private void drawTickPath(Canvas canvas) {
        this.mTickPath.reset();
        if (this.mDrewDistance < this.mLeftLineDistance) {
            float f2 = (float)this.mWidth / this.mTickSpeed < 1.0f ? 1.0f : (float)this.mWidth / this.mTickSpeed;
            this.mDrewDistance += f2;
            float f3 = (float)this.mTickPoints[0].x + (float)(this.mTickPoints[1].x - this.mTickPoints[0].x) * this.mDrewDistance / this.mLeftLineDistance;
            f2 = (float)this.mTickPoints[0].y + (float)(this.mTickPoints[1].y - this.mTickPoints[0].y) * this.mDrewDistance / this.mLeftLineDistance;
            this.mTickPath.moveTo((float)this.mTickPoints[0].x, (float)this.mTickPoints[0].y);
            this.mTickPath.lineTo(f3, f2);
            canvas.drawPath(this.mTickPath, this.mTickPaint);
            if (this.mDrewDistance > this.mLeftLineDistance) {
                this.mDrewDistance = this.mLeftLineDistance;
            }
        } else {
            this.mTickPath.moveTo((float)this.mTickPoints[0].x, (float)this.mTickPoints[0].y);
            this.mTickPath.lineTo((float)this.mTickPoints[1].x, (float)this.mTickPoints[1].y);
            canvas.drawPath(this.mTickPath, this.mTickPaint);
            if (this.mDrewDistance < this.mLeftLineDistance + this.mRightLineDistance) {
                float f4 = (float)this.mTickPoints[1].x + (float)(this.mTickPoints[2].x - this.mTickPoints[1].x) * (this.mDrewDistance - this.mLeftLineDistance) / this.mRightLineDistance;
                float f5 = (float)this.mTickPoints[1].y - (float)(this.mTickPoints[1].y - this.mTickPoints[2].y) * (this.mDrewDistance - this.mLeftLineDistance) / this.mRightLineDistance;
                this.mTickPath.reset();
                this.mTickPath.moveTo((float)this.mTickPoints[1].x, (float)this.mTickPoints[1].y);
                this.mTickPath.lineTo(f4, f5);
                canvas.drawPath(this.mTickPath, this.mTickPaint);
                f4 = (float)this.mWidth / this.mTickSpeed < 1.0f ? 1.0f : (float)this.mWidth / this.mTickSpeed;
                this.mDrewDistance += f4;
            } else {
                this.mTickPath.reset();
                this.mTickPath.moveTo((float)this.mTickPoints[1].x, (float)this.mTickPoints[1].y);
                this.mTickPath.lineTo((float)this.mTickPoints[2].x, (float)this.mTickPoints[2].y);
                canvas.drawPath(this.mTickPath, this.mTickPaint);
            }
        }
        if (this.mDrewDistance < this.mLeftLineDistance + this.mRightLineDistance) {
            this.postDelayed(new SmoothCheckBox$2(this), 10L);
        }
    }

    private void startCheckedAnimation() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        valueAnimator.setDuration((long)(this.mAnimDuration / 3 << 1));
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new SmoothCheckBox$3(this));
        valueAnimator.start();
        valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f});
        valueAnimator.setDuration((long)this.mAnimDuration);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new SmoothCheckBox$4(this));
        valueAnimator.start();
        this.drawTickDelayed();
    }

    private void startUnCheckedAnimation() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration((long)this.mAnimDuration);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new SmoothCheckBox$5(this));
        valueAnimator.start();
        valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f});
        valueAnimator.setDuration((long)this.mAnimDuration);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new SmoothCheckBox$6(this));
        valueAnimator.start();
    }

    private void drawTickDelayed() {
        this.postDelayed(new SmoothCheckBox$7(this), this.mAnimDuration);
    }

    private static int getGradientColor(int n2, int n3, float f2) {
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        n2 &= 0xFF;
        int n6 = n3 >> 16 & 0xFF;
        int n7 = n3 >> 8 & 0xFF;
        n4 = (int)((float)n4 * (1.0f - f2) + (float)n6 * f2);
        n5 = (int)((float)n5 * (1.0f - f2) + (float)n7 * f2);
        n2 = (int)((float)n2 * (1.0f - f2) + (float)(n3 &= 0xFF) * f2);
        return Color.argb((int)255, (int)n4, (int)n5, (int)n2);
    }

    public void setOnCheckedChangeListener(SmoothCheckBox$OnCheckedChangeListener smoothCheckBox$OnCheckedChangeListener) {
        this.mListener = smoothCheckBox$OnCheckedChangeListener;
    }

    public void setTickColor(@ColorInt int n2) {
        this.mTickPaint.setColor(n2);
        this.reset();
        this.invalidate();
    }

    public void setCheckedColor(@ColorInt int n2) {
        this.mCheckedColor = n2;
        this.reset();
        this.invalidate();
    }

    static /* synthetic */ boolean access$002(SmoothCheckBox smoothCheckBox, boolean bl) {
        smoothCheckBox.mTickDrawing = bl;
        return smoothCheckBox.mTickDrawing;
    }

    static /* synthetic */ float access$102(SmoothCheckBox smoothCheckBox, float f2) {
        smoothCheckBox.mDrewDistance = f2;
        return smoothCheckBox.mDrewDistance;
    }

    static /* synthetic */ void access$200(SmoothCheckBox smoothCheckBox) {
        smoothCheckBox.startCheckedAnimation();
    }

    static /* synthetic */ void access$300(SmoothCheckBox smoothCheckBox) {
        smoothCheckBox.startUnCheckedAnimation();
    }

    static /* synthetic */ float access$402(SmoothCheckBox smoothCheckBox, float f2) {
        smoothCheckBox.mScaleVal = f2;
        return smoothCheckBox.mScaleVal;
    }

    static /* synthetic */ int access$502(SmoothCheckBox smoothCheckBox, int n2) {
        smoothCheckBox.mFloorColor = n2;
        return smoothCheckBox.mFloorColor;
    }

    static /* synthetic */ int access$600(SmoothCheckBox smoothCheckBox) {
        return smoothCheckBox.mUnCheckedColor;
    }

    static /* synthetic */ int access$700(SmoothCheckBox smoothCheckBox) {
        return smoothCheckBox.mCheckedColor;
    }

    static /* synthetic */ float access$400(SmoothCheckBox smoothCheckBox) {
        return smoothCheckBox.mScaleVal;
    }

    static /* synthetic */ int access$800(int n2, int n3, float f2) {
        return SmoothCheckBox.getGradientColor(n2, n3, f2);
    }

    static /* synthetic */ float access$902(SmoothCheckBox smoothCheckBox, float f2) {
        smoothCheckBox.mFloorScale = f2;
        return smoothCheckBox.mFloorScale;
    }

    static /* synthetic */ int access$1000(SmoothCheckBox smoothCheckBox) {
        return smoothCheckBox.mFloorUnCheckedColor;
    }
}

