/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.util;

import com.zoyi.channel.plugin.android.view.external.nineoldandroids.util.NoSuchPropertyException;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.util.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ReflectiveProperty<T, V>
extends Property<T, V> {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_SET = "set";
    private Method mSetter;
    private Method mGetter;
    private Field mField;

    public ReflectiveProperty(Class<T> clazz, Class<V> object, String object2) {
        super(object, (String)object2);
        char c2 = Character.toUpperCase(((String)object2).charAt(0));
        String string2 = ((String)object2).substring(1);
        String string3 = c2 + string2;
        string2 = PREFIX_GET + string3;
        try {
            this.mGetter = clazz.getMethod(string2, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                this.mGetter = clazz.getDeclaredMethod(string2, null);
                this.mGetter.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                string2 = PREFIX_IS + string3;
                try {
                    this.mGetter = clazz.getMethod(string2, null);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    try {
                        this.mGetter = clazz.getDeclaredMethod(string2, null);
                        this.mGetter.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException4) {
                        try {
                            this.mField = clazz.getField((String)object2);
                            clazz = this.mField.getType();
                            if (!this.typesMatch((Class<V>)object, clazz)) {
                                throw new NoSuchPropertyException("Underlying type (" + clazz + ") does not match Property type (" + object + ")");
                            }
                            return;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            throw new NoSuchPropertyException("No accessor method or field found for property with name " + (String)object2);
                        }
                    }
                }
            }
        }
        object2 = this.mGetter.getReturnType();
        if (!this.typesMatch((Class<V>)object, (Class)object2)) {
            throw new NoSuchPropertyException("Underlying type (" + object2 + ") does not match Property type (" + object + ")");
        }
        object = PREFIX_SET + string3;
        try {
            this.mSetter = clazz.getDeclaredMethod((String)object, new Class[]{object2});
            this.mSetter.setAccessible(true);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
    }

    private boolean typesMatch(Class<V> clazz, Class clazz2) {
        if (clazz2 != clazz) {
            if (clazz2.isPrimitive()) {
                return clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Double.TYPE && clazz == Double.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Byte.TYPE && clazz == Byte.class || clazz2 == Character.TYPE && clazz == Character.class;
            }
            return false;
        }
        return true;
    }

    @Override
    public void set(T t2, V v2) {
        if (this.mSetter != null) {
            try {
                this.mSetter.invoke(t2, v2);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
        if (this.mField != null) {
            try {
                this.mField.set(t2, v2);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        throw new UnsupportedOperationException("Property " + this.getName() + " is read-only");
    }

    @Override
    public V get(T t2) {
        if (this.mGetter != null) {
            try {
                return (V)this.mGetter.invoke(t2, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
        if (this.mField != null) {
            try {
                return (V)this.mField.get(t2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isReadOnly() {
        return this.mSetter == null && this.mField == null;
    }
}

