/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation;

import android.view.View;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.PreHoneycombCompat;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.PropertyValuesHolder;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.TypeEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.util.Property;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.animation.AnimatorProxy;
import java.util.HashMap;
import java.util.Map;

public final class ObjectAnimator
extends ValueAnimator {
    private static final boolean DBG = false;
    private static final Map<String, Property> PROXY_PROPERTIES = new HashMap<String, Property>();
    private Object mTarget;
    private String mPropertyName;
    private Property mProperty;

    public final void setPropertyName(String string2) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string3 = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setPropertyName(string2);
            this.mValuesMap.remove(string3);
            this.mValuesMap.put(string2, propertyValuesHolder);
        }
        this.mPropertyName = string2;
        this.mInitialized = false;
    }

    public final void setProperty(Property property) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string2 = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setProperty(property);
            this.mValuesMap.remove(string2);
            this.mValuesMap.put(this.mPropertyName, propertyValuesHolder);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        this.mProperty = property;
        this.mInitialized = false;
    }

    public final String getPropertyName() {
        return this.mPropertyName;
    }

    public ObjectAnimator() {
    }

    private ObjectAnimator(Object object, String string2) {
        this.mTarget = object;
        this.setPropertyName(string2);
    }

    private <T> ObjectAnimator(T t2, Property<T, ?> property) {
        this.mTarget = t2;
        this.setProperty(property);
    }

    public static ObjectAnimator ofInt(Object object, String string2, int ... nArray) {
        object = new ObjectAnimator(object, string2);
        ((ObjectAnimator)object).setIntValues(nArray);
        return object;
    }

    public static <T> ObjectAnimator ofInt(T object, Property<T, Integer> property, int ... nArray) {
        object = new ObjectAnimator(object, property);
        ((ObjectAnimator)object).setIntValues(nArray);
        return object;
    }

    public static ObjectAnimator ofFloat(Object object, String string2, float ... fArray) {
        object = new ObjectAnimator(object, string2);
        ((ObjectAnimator)object).setFloatValues(fArray);
        return object;
    }

    public static <T> ObjectAnimator ofFloat(T object, Property<T, Float> property, float ... fArray) {
        object = new ObjectAnimator(object, property);
        ((ObjectAnimator)object).setFloatValues(fArray);
        return object;
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        object = new ObjectAnimator(object, string2);
        ((ObjectAnimator)object).setObjectValues(objectArray);
        ((ValueAnimator)object).setEvaluator(typeEvaluator);
        return object;
    }

    public static <T, V> ObjectAnimator ofObject(T object, Property<T, V> property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        object = new ObjectAnimator(object, property);
        ((ObjectAnimator)object).setObjectValues(VArray);
        ((ValueAnimator)object).setEvaluator(typeEvaluator);
        return object;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object object, PropertyValuesHolder ... propertyValuesHolderArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        new ObjectAnimator().mTarget = object;
        objectAnimator.setValues(propertyValuesHolderArray);
        return objectAnimator;
    }

    @Override
    public final void setIntValues(int ... nArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofInt(this.mProperty, nArray));
                return;
            }
            this.setValues(PropertyValuesHolder.ofInt(this.mPropertyName, nArray));
            return;
        }
        super.setIntValues(nArray);
    }

    @Override
    public final void setFloatValues(float ... fArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofFloat(this.mProperty, fArray));
                return;
            }
            this.setValues(PropertyValuesHolder.ofFloat(this.mPropertyName, fArray));
            return;
        }
        super.setFloatValues(fArray);
    }

    @Override
    public final void setObjectValues(Object ... objectArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofObject(this.mProperty, null, objectArray));
                return;
            }
            this.setValues(PropertyValuesHolder.ofObject(this.mPropertyName, null, objectArray));
            return;
        }
        super.setObjectValues(objectArray);
    }

    @Override
    public final void start() {
        super.start();
    }

    @Override
    final void initAnimation() {
        if (!this.mInitialized) {
            if (this.mProperty == null && AnimatorProxy.NEEDS_PROXY && this.mTarget instanceof View && PROXY_PROPERTIES.containsKey(this.mPropertyName)) {
                this.setProperty(PROXY_PROPERTIES.get(this.mPropertyName));
            }
            int n2 = this.mValues.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mValues[i2].setupSetterAndGetter(this.mTarget);
            }
            super.initAnimation();
        }
    }

    @Override
    public final ObjectAnimator setDuration(long l2) {
        super.setDuration(l2);
        return this;
    }

    public final Object getTarget() {
        return this.mTarget;
    }

    @Override
    public final void setTarget(Object object) {
        if (this.mTarget != object) {
            Object object2 = this.mTarget;
            this.mTarget = object;
            if (object2 != null && object != null && object2.getClass() == object.getClass()) {
                return;
            }
            this.mInitialized = false;
        }
    }

    @Override
    public final void setupStartValues() {
        this.initAnimation();
        int n2 = this.mValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mValues[i2].setupStartValue(this.mTarget);
        }
    }

    @Override
    public final void setupEndValues() {
        this.initAnimation();
        int n2 = this.mValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mValues[i2].setupEndValue(this.mTarget);
        }
    }

    @Override
    final void animateValue(float f2) {
        super.animateValue(f2);
        int n2 = this.mValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mValues[i2].setAnimatedValue(this.mTarget);
        }
    }

    @Override
    public final ObjectAnimator clone() {
        ObjectAnimator objectAnimator = (ObjectAnimator)super.clone();
        return objectAnimator;
    }

    @Override
    public final String toString() {
        String string2 = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.mTarget;
        if (this.mValues != null) {
            for (int i2 = 0; i2 < this.mValues.length; ++i2) {
                string2 = string2 + "\n    " + this.mValues[i2].toString();
            }
        }
        return string2;
    }

    static {
        PROXY_PROPERTIES.put("alpha", PreHoneycombCompat.ALPHA);
        PROXY_PROPERTIES.put("pivotX", PreHoneycombCompat.PIVOT_X);
        PROXY_PROPERTIES.put("pivotY", PreHoneycombCompat.PIVOT_Y);
        PROXY_PROPERTIES.put("translationX", PreHoneycombCompat.TRANSLATION_X);
        PROXY_PROPERTIES.put("translationY", PreHoneycombCompat.TRANSLATION_Y);
        PROXY_PROPERTIES.put("rotation", PreHoneycombCompat.ROTATION);
        PROXY_PROPERTIES.put("rotationX", PreHoneycombCompat.ROTATION_X);
        PROXY_PROPERTIES.put("rotationY", PreHoneycombCompat.ROTATION_Y);
        PROXY_PROPERTIES.put("scaleX", PreHoneycombCompat.SCALE_X);
        PROXY_PROPERTIES.put("scaleY", PreHoneycombCompat.SCALE_Y);
        PROXY_PROPERTIES.put("scrollX", PreHoneycombCompat.SCROLL_X);
        PROXY_PROPERTIES.put("scrollY", PreHoneycombCompat.SCROLL_Y);
        PROXY_PROPERTIES.put("x", PreHoneycombCompat.X);
        PROXY_PROPERTIES.put("y", PreHoneycombCompat.Y);
    }
}

