/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Animator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Animator$AnimatorListener;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet$1;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet$AnimatorSetListener;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet$Builder;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet$Dependency;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet$DependencyListener;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet$Node;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ObjectAnimator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class AnimatorSet
extends Animator {
    private ArrayList<Animator> mPlayingSet = new ArrayList();
    private HashMap<Animator, AnimatorSet$Node> mNodeMap = new HashMap();
    private ArrayList<AnimatorSet$Node> mNodes = new ArrayList();
    private ArrayList<AnimatorSet$Node> mSortedNodes = new ArrayList();
    private boolean mNeedsSort = true;
    private AnimatorSet$AnimatorSetListener mSetListener = null;
    boolean mTerminated = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = null;
    private long mDuration = -1L;

    public final void playTogether(Animator ... animatorArray) {
        if (animatorArray != null) {
            this.mNeedsSort = true;
            AnimatorSet$Builder animatorSet$Builder = this.play(animatorArray[0]);
            for (int i2 = 1; i2 < animatorArray.length; ++i2) {
                animatorSet$Builder.with(animatorArray[i2]);
            }
        }
    }

    public final void playTogether(Collection<Animator> object) {
        if (object != null && object.size() > 0) {
            this.mNeedsSort = true;
            AnimatorSet$Builder animatorSet$Builder = null;
            object = object.iterator();
            while (object.hasNext()) {
                Animator animator = (Animator)object.next();
                if (animatorSet$Builder == null) {
                    animatorSet$Builder = this.play(animator);
                    continue;
                }
                animatorSet$Builder.with(animator);
            }
        }
    }

    public final void playSequentially(Animator ... animatorArray) {
        if (animatorArray != null) {
            this.mNeedsSort = true;
            if (animatorArray.length == 1) {
                this.play(animatorArray[0]);
                return;
            }
            for (int i2 = 0; i2 < animatorArray.length - 1; ++i2) {
                this.play(animatorArray[i2]).before(animatorArray[i2 + 1]);
            }
        }
    }

    public final void playSequentially(List<Animator> list) {
        if (list != null && list.size() > 0) {
            this.mNeedsSort = true;
            if (list.size() == 1) {
                this.play(list.get(0));
                return;
            }
            for (int i2 = 0; i2 < list.size() - 1; ++i2) {
                this.play(list.get(i2)).before(list.get(i2 + 1));
            }
        }
    }

    public final ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        for (AnimatorSet$Node animatorSet$Node : this.mNodes) {
            arrayList.add(animatorSet$Node.animation);
        }
        return arrayList;
    }

    @Override
    public final void setTarget(Object object) {
        for (Cloneable cloneable : this.mNodes) {
            cloneable = cloneable.animation;
            if (cloneable instanceof AnimatorSet) {
                ((AnimatorSet)cloneable).setTarget(object);
                continue;
            }
            if (!(cloneable instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)cloneable).setTarget(object);
        }
    }

    @Override
    public final void setInterpolator(Interpolator interpolator) {
        for (AnimatorSet$Node animatorSet$Node : this.mNodes) {
            animatorSet$Node.animation.setInterpolator(interpolator);
        }
    }

    public final AnimatorSet$Builder play(Animator animator) {
        if (animator != null) {
            this.mNeedsSort = true;
            return new AnimatorSet$Builder(this, animator);
        }
        return null;
    }

    @Override
    public final void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList arrayList = null;
            if (this.mListeners != null) {
                arrayList = (ArrayList)this.mListeners.clone();
                for (Animator$AnimatorListener object : arrayList) {
                    object.onAnimationCancel(this);
                }
            }
            if (this.mDelayAnim != null && this.mDelayAnim.isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                for (AnimatorSet$Node animatorSet$Node : this.mSortedNodes) {
                    animatorSet$Node.animation.cancel();
                }
            }
            if (arrayList != null) {
                for (Animator$AnimatorListener animator$AnimatorListener : arrayList) {
                    animator$AnimatorListener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public final void end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                this.sortNodes();
                for (AnimatorSet$Node object : this.mSortedNodes) {
                    if (this.mSetListener == null) {
                        this.mSetListener = new AnimatorSet$AnimatorSetListener(this, this);
                    }
                    object.animation.addListener(this.mSetListener);
                }
            }
            if (this.mDelayAnim != null) {
                this.mDelayAnim.cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                for (AnimatorSet$Node animatorSet$Node : this.mSortedNodes) {
                    animatorSet$Node.animation.end();
                }
            }
            if (this.mListeners != null) {
                Object object2 = (ArrayList)this.mListeners.clone();
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    object2 = (Animator$AnimatorListener)iterator.next();
                    object2.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public final boolean isRunning() {
        for (AnimatorSet$Node animatorSet$Node : this.mNodes) {
            if (!animatorSet$Node.animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public final long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public final void setStartDelay(long l2) {
        this.mStartDelay = l2;
    }

    @Override
    public final long getDuration() {
        return this.mDuration;
    }

    @Override
    public final AnimatorSet setDuration(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        for (AnimatorSet$Node animatorSet$Node : this.mNodes) {
            animatorSet$Node.animation.setDuration(l2);
        }
        this.mDuration = l2;
        return this;
    }

    @Override
    public final void setupStartValues() {
        for (AnimatorSet$Node animatorSet$Node : this.mNodes) {
            animatorSet$Node.animation.setupStartValues();
        }
    }

    @Override
    public final void setupEndValues() {
        for (AnimatorSet$Node animatorSet$Node : this.mNodes) {
            animatorSet$Node.animation.setupEndValues();
        }
    }

    @Override
    public final void start() {
        Cloneable cloneable22;
        this.mTerminated = false;
        this.mStarted = true;
        this.sortNodes();
        int n2 = this.mSortedNodes.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AnimatorSet$Node animatorSet$Node = this.mSortedNodes.get(i2);
            cloneable22 = animatorSet$Node.animation.getListeners();
            if (cloneable22 == null || cloneable22.size() <= 0) continue;
            ArrayList<Animator$AnimatorListener> arrayList = new ArrayList<Animator$AnimatorListener>((Collection<Animator$AnimatorListener>)((Object)cloneable22));
            for (Animator$AnimatorListener object : arrayList) {
                if (!(object instanceof AnimatorSet$DependencyListener) && !(object instanceof AnimatorSet$AnimatorSetListener)) continue;
                animatorSet$Node.animation.removeListener(object);
            }
        }
        ArrayList<ArrayList<Animator$AnimatorListener>> arrayList = new ArrayList<ArrayList<Animator$AnimatorListener>>();
        for (int i3 = 0; i3 < n2; ++i3) {
            cloneable22 = this.mSortedNodes.get(i3);
            if (this.mSetListener == null) {
                this.mSetListener = new AnimatorSet$AnimatorSetListener(this, this);
            }
            if (((AnimatorSet$Node)cloneable22).dependencies == null || ((AnimatorSet$Node)cloneable22).dependencies.size() == 0) {
                arrayList.add((ArrayList<Animator$AnimatorListener>)cloneable22);
            } else {
                int n3 = ((AnimatorSet$Node)cloneable22).dependencies.size();
                for (int i4 = 0; i4 < n3; ++i4) {
                    AnimatorSet$Dependency animatorSet$Dependency = ((AnimatorSet$Node)cloneable22).dependencies.get(i4);
                    animatorSet$Dependency.node.animation.addListener(new AnimatorSet$DependencyListener(this, (AnimatorSet$Node)cloneable22, animatorSet$Dependency.rule));
                }
                ((AnimatorSet$Node)cloneable22).tmpDependencies = (ArrayList)((AnimatorSet$Node)cloneable22).dependencies.clone();
            }
            ((AnimatorSet$Node)cloneable22).animation.addListener(this.mSetListener);
        }
        if (this.mStartDelay <= 0L) {
            for (Cloneable cloneable22 : arrayList) {
                ((AnimatorSet$Node)cloneable22).animation.start();
                this.mPlayingSet.add(((AnimatorSet$Node)cloneable22).animation);
            }
        } else {
            this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mDelayAnim.setDuration(this.mStartDelay);
            this.mDelayAnim.addListener(new AnimatorSet$1(this, arrayList));
            this.mDelayAnim.start();
        }
        if (this.mListeners != null) {
            ArrayList arrayList2 = (ArrayList)this.mListeners.clone();
            int n4 = arrayList2.size();
            for (int i5 = 0; i5 < n4; ++i5) {
                ((Animator$AnimatorListener)arrayList2.get(i5)).onAnimationStart(this);
            }
        }
        if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
            this.mStarted = false;
            if (this.mListeners != null) {
                ArrayList arrayList3 = (ArrayList)this.mListeners.clone();
                int n5 = arrayList3.size();
                for (int i6 = 0; i6 < n5; ++i6) {
                    ((Animator$AnimatorListener)arrayList3.get(i6)).onAnimationEnd(this);
                }
            }
        }
    }

    @Override
    public final AnimatorSet clone() {
        Iterator iterator;
        AnimatorSet$Node animatorSet$Node;
        AnimatorSet animatorSet = (AnimatorSet)super.clone();
        ((AnimatorSet)super.clone()).mNeedsSort = true;
        animatorSet.mTerminated = false;
        animatorSet.mStarted = false;
        animatorSet.mPlayingSet = new ArrayList();
        animatorSet.mNodeMap = new HashMap();
        animatorSet.mNodes = new ArrayList();
        animatorSet.mSortedNodes = new ArrayList();
        HashMap<AnimatorSet$Node, AnimatorSet$Node> hashMap = new HashMap<AnimatorSet$Node, AnimatorSet$Node>();
        for (AnimatorSet$Node animatorSet$Node2 : this.mNodes) {
            animatorSet$Node = animatorSet$Node2.clone();
            hashMap.put(animatorSet$Node2, animatorSet$Node);
            animatorSet.mNodes.add(animatorSet$Node);
            animatorSet.mNodeMap.put(animatorSet$Node.animation, animatorSet$Node);
            animatorSet$Node.dependencies = null;
            animatorSet$Node.tmpDependencies = null;
            animatorSet$Node.nodeDependents = null;
            animatorSet$Node.nodeDependencies = null;
            ArrayList<Animator$AnimatorListener> arrayList = animatorSet$Node.animation.getListeners();
            if (arrayList == null) continue;
            Object object = null;
            for (Animator$AnimatorListener animator$AnimatorListener : arrayList) {
                if (!(animator$AnimatorListener instanceof AnimatorSet$AnimatorSetListener)) continue;
                if (object == null) {
                    object = new ArrayList();
                }
                ((ArrayList)object).add(animator$AnimatorListener);
            }
            if (object == null) continue;
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Animator$AnimatorListener animator$AnimatorListener = (Animator$AnimatorListener)iterator.next();
                arrayList.remove(animator$AnimatorListener);
            }
        }
        for (AnimatorSet$Node animatorSet$Node3 : this.mNodes) {
            animatorSet$Node = (AnimatorSet$Node)hashMap.get(animatorSet$Node3);
            if (animatorSet$Node3.dependencies == null) continue;
            for (Object object : animatorSet$Node3.dependencies) {
                iterator = (AnimatorSet$Node)hashMap.get(((AnimatorSet$Dependency)object).node);
                AnimatorSet$Dependency animatorSet$Dependency = new AnimatorSet$Dependency((AnimatorSet$Node)((Object)iterator), ((AnimatorSet$Dependency)object).rule);
                animatorSet$Node.addDependency(animatorSet$Dependency);
            }
        }
        return animatorSet;
    }

    private void sortNodes() {
        if (this.mNeedsSort) {
            this.mSortedNodes.clear();
            ArrayList<AnimatorSet$Node> arrayList = new ArrayList<AnimatorSet$Node>();
            int n2 = this.mNodes.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                AnimatorSet$Node animatorSet$Node = this.mNodes.get(i2);
                if (animatorSet$Node.dependencies != null && animatorSet$Node.dependencies.size() != 0) continue;
                arrayList.add(animatorSet$Node);
            }
            ArrayList<AnimatorSet$Node> arrayList2 = new ArrayList<AnimatorSet$Node>();
            while (arrayList.size() > 0) {
                int n3 = arrayList.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    AnimatorSet$Node animatorSet$Node = (AnimatorSet$Node)arrayList.get(i3);
                    this.mSortedNodes.add(animatorSet$Node);
                    if (animatorSet$Node.nodeDependents == null) continue;
                    n2 = animatorSet$Node.nodeDependents.size();
                    for (int i4 = 0; i4 < n2; ++i4) {
                        AnimatorSet$Node animatorSet$Node2 = animatorSet$Node.nodeDependents.get(i4);
                        animatorSet$Node2.nodeDependencies.remove(animatorSet$Node);
                        if (animatorSet$Node2.nodeDependencies.size() != 0) continue;
                        arrayList2.add(animatorSet$Node2);
                    }
                }
                arrayList.clear();
                arrayList.addAll(arrayList2);
                arrayList2.clear();
            }
            this.mNeedsSort = false;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
            }
            return;
        }
        int n4 = this.mNodes.size();
        for (int i5 = 0; i5 < n4; ++i5) {
            AnimatorSet$Node animatorSet$Node = this.mNodes.get(i5);
            if (animatorSet$Node.dependencies != null && animatorSet$Node.dependencies.size() > 0) {
                int n5 = animatorSet$Node.dependencies.size();
                for (int i6 = 0; i6 < n5; ++i6) {
                    AnimatorSet$Dependency animatorSet$Dependency = animatorSet$Node.dependencies.get(i6);
                    if (animatorSet$Node.nodeDependencies == null) {
                        animatorSet$Node.nodeDependencies = new ArrayList();
                    }
                    if (animatorSet$Node.nodeDependencies.contains(animatorSet$Dependency.node)) continue;
                    animatorSet$Node.nodeDependencies.add(animatorSet$Dependency.node);
                }
            }
            animatorSet$Node.done = false;
        }
    }

    static /* synthetic */ ArrayList access$000(AnimatorSet animatorSet) {
        return animatorSet.mPlayingSet;
    }

    static /* synthetic */ HashMap access$100(AnimatorSet animatorSet) {
        return animatorSet.mNodeMap;
    }

    static /* synthetic */ ArrayList access$200(AnimatorSet animatorSet) {
        return animatorSet.mSortedNodes;
    }

    static /* synthetic */ boolean access$302(AnimatorSet animatorSet, boolean bl) {
        animatorSet.mStarted = bl;
        return animatorSet.mStarted;
    }

    static /* synthetic */ ArrayList access$400(AnimatorSet animatorSet) {
        return animatorSet.mNodes;
    }
}

