/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.fab;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AbsListView;

abstract class AbsListViewScrollDetector
implements AbsListView.OnScrollListener {
    private int mLastScrollY;
    private int mPreviousFirstVisibleItem;
    private AbsListView mListView;
    private int mScrollThreshold;

    AbsListViewScrollDetector() {
    }

    abstract void onScrollUp();

    abstract void onScrollDown();

    public void onScrollStateChanged(AbsListView absListView, int n2) {
    }

    public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        if (n4 == 0) {
            return;
        }
        if (this.isSameRow(n2)) {
            int n5 = this.getTopItemScrollY();
            n2 = Math.abs(this.mLastScrollY - n5) > this.mScrollThreshold ? 1 : 0;
            if (n2 != 0) {
                if (this.mLastScrollY > n5) {
                    this.onScrollUp();
                } else {
                    this.onScrollDown();
                }
            }
            this.mLastScrollY = n5;
            return;
        }
        if (n2 > this.mPreviousFirstVisibleItem) {
            this.onScrollUp();
        } else {
            this.onScrollDown();
        }
        this.mLastScrollY = this.getTopItemScrollY();
        this.mPreviousFirstVisibleItem = n2;
    }

    public void setScrollThreshold(int n2) {
        this.mScrollThreshold = n2;
    }

    public void setListView(@NonNull AbsListView absListView) {
        this.mListView = absListView;
    }

    private boolean isSameRow(int n2) {
        return n2 == this.mPreviousFirstVisibleItem;
    }

    private int getTopItemScrollY() {
        if (this.mListView == null || this.mListView.getChildAt(0) == null) {
            return 0;
        }
        View view = this.mListView.getChildAt(0);
        return view.getTop();
    }
}

