/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatHolder;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract$Model;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract$View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class UserChatListAdapter
extends RecyclerView.Adapter<UserChatHolder>
implements UserChatAdapterContract$Model,
UserChatAdapterContract$View {
    private OnUserChatClickListener listener;
    private Map<String, UserChatItem> map = new HashMap<String, UserChatItem>();
    private UserChatListDataDictionary dictionary = new UserChatListDataDictionary();
    private SortedList<UserChatItem> items = new SortedList(UserChatItem.class, new SortedListCallback(this, true));
    private boolean refreshBySocket = false;

    UserChatListAdapter() {
    }

    @Override
    public void setOnUserChatClickListener(OnUserChatClickListener onUserChatClickListener) {
        this.listener = onUserChatClickListener;
    }

    @Override
    public void init(UserChatsWrapper iterator) {
        this.dictionary.add(((UserChatsWrapper)((Object)iterator)).getManagers());
        this.dictionary.add(((UserChatsWrapper)((Object)iterator)).getSessions());
        this.dictionary.add(((UserChatsWrapper)((Object)iterator)).getMessages());
        ArrayList<UserChatItem> arrayList = new ArrayList<UserChatItem>();
        for (UserChat object : ((UserChatsWrapper)((Object)iterator)).getUserChats()) {
            UserChatItem userChatItem = new UserChatItem(object, this.dictionary);
            if (this.map.containsKey(object.getId())) {
                this.items.remove((Object)this.map.get(object.getId()));
            }
            arrayList.add(userChatItem);
        }
        for (UserChatItem userChatItem : arrayList) {
            this.map.put(userChatItem.getId(), userChatItem);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        this.refreshBySocket = true;
    }

    @Override
    public void stopRefreshBySocket() {
        this.refreshBySocket = false;
    }

    public UserChatHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        Context context = viewGroup.getContext();
        viewGroup = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_item_user_chat, viewGroup, false);
        return new UserChatHolder((View)viewGroup, this.listener);
    }

    public void onBindViewHolder(UserChatHolder userChatHolder, int n2) {
        userChatHolder.setUserChatItem((UserChatItem)this.items.get(n2));
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void receiveChannelModel(ChannelModel channelModel, boolean bl) {
        if (!this.refreshBySocket) {
            return;
        }
        if (bl) {
            this.dictionary.add(channelModel);
        } else {
            this.dictionary.remove(channelModel);
        }
        switch (channelModel.getClass().getSimpleName()) {
            case "UserChat": {
                this.updateUserChat((UserChat)channelModel, bl);
                return;
            }
            case "Session": {
                this.updateSession((Session)channelModel);
                return;
            }
            case "Manager": {
                this.updateManager(channelModel.getId());
            }
        }
    }

    private void updateUserChat(UserChat userChat, boolean bl) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            UserChatItem userChatItem = (UserChatItem)this.items.get(i2);
            if (!userChatItem.getId().equals(userChat.getId())) continue;
            if (bl) {
                userChatItem.setUserChat(userChat);
                this.items.updateItemAt(i2, (Object)userChatItem);
                return;
            }
            this.items.removeItemAt(i2);
            return;
        }
        this.items.add((Object)new UserChatItem(userChat, this.dictionary));
    }

    private void updateManager(String string2) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            UserChatItem userChatItem = (UserChatItem)this.items.get(i2);
            if (!userChatItem.containsManager(string2)) continue;
            this.items.updateItemAt(i2, (Object)userChatItem);
        }
    }

    private void updateSession(Session session) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            UserChatItem userChatItem = (UserChatItem)this.items.get(i2);
            if (!userChatItem.getSessionId().equals(session.getId())) continue;
            userChatItem.setSession(session);
            this.items.updateItemAt(i2, (Object)userChatItem);
            return;
        }
    }
}

