/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import java.util.List;

class UserChatHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private Context context;
    private View singleAvatar;
    private View doubleAvatar;
    private View tripleAvatar;
    private AvatarLayout avatarSingle;
    private AvatarLayout avatarDouble1;
    private AvatarLayout avatarDouble2;
    private AvatarLayout avatarTriple1;
    private AvatarLayout avatarTriple2;
    private AvatarLayout avatarTriple3;
    private TextView textName;
    private TextView textTime;
    private TextView textMessage;
    private TextView textBadge;
    private UserChat userChat;
    private OnUserChatClickListener listener;

    UserChatHolder(View view, OnUserChatClickListener onUserChatClickListener) {
        super(view);
        this.context = view.getContext();
        this.listener = onUserChatClickListener;
        this.singleAvatar = view.findViewById(R.id.layout_single);
        this.doubleAvatar = view.findViewById(R.id.layout_double);
        this.tripleAvatar = view.findViewById(R.id.layout_triple);
        this.avatarSingle = (AvatarLayout)view.findViewById(R.id.avatar_single);
        this.avatarDouble1 = (AvatarLayout)view.findViewById(R.id.avatar_double1);
        this.avatarDouble2 = (AvatarLayout)view.findViewById(R.id.avatar_double2);
        this.avatarTriple1 = (AvatarLayout)view.findViewById(R.id.avatar_triple1);
        this.avatarTriple2 = (AvatarLayout)view.findViewById(R.id.avatar_triple2);
        this.avatarTriple3 = (AvatarLayout)view.findViewById(R.id.avatar_triple3);
        this.avatarSingle.setTextSize(16);
        this.avatarDouble1.setTextSize(14);
        this.avatarDouble2.setTextSize(14);
        this.avatarTriple1.setTextSize(10);
        this.avatarTriple2.setTextSize(10);
        this.avatarTriple3.setTextSize(10);
        this.textName = (TextView)view.findViewById(R.id.text_name);
        this.textTime = (TextView)view.findViewById(R.id.text_time);
        this.textMessage = (TextView)view.findViewById(R.id.text_message);
        this.textBadge = (TextView)view.findViewById(R.id.text_badge);
        view.setOnClickListener((View.OnClickListener)this);
    }

    void setUserChatItem(UserChatItem object) {
        this.userChat = ((UserChatItem)object).getUserChat();
        Message message = ((UserChatItem)object).getMessage();
        Session session = ((UserChatItem)object).getSession();
        object = ((UserChatItem)object).getProfiles();
        this.textName.setText((CharSequence)UIUtils.getNamesString((List<? extends ProfileEntity>)object));
        if (message != null) {
            if (message.getFile() == null && message.getMessage() != null) {
                this.textMessage.setText((CharSequence)message.getMessage());
            } else {
                this.textMessage.setText((CharSequence)ResUtils.getString(this.context, "ch.notification.upload_file.description"));
            }
        } else {
            this.textMessage.setText((CharSequence)"");
        }
        if (this.userChat != null && this.userChat.getUpdatedAt() != null) {
            this.textTime.setText((CharSequence)TimeUtils.get(this.userChat.getUpdatedAt()));
        } else {
            this.textTime.setText((CharSequence)"");
        }
        if (session != null && session.getAlert() != null && session.getAlert() > 0) {
            this.textBadge.setVisibility(0);
            this.textBadge.setText((CharSequence)Utils.getCount(session.getAlert(), true));
        } else {
            this.textBadge.setVisibility(8);
        }
        this.singleAvatar.setVisibility(8);
        this.doubleAvatar.setVisibility(8);
        this.tripleAvatar.setVisibility(8);
        if (object.size() == 1) {
            this.singleAvatar.setVisibility(0);
            this.avatarSingle.set((ProfileEntity)object.get(0));
            return;
        }
        if (object.size() == 2) {
            this.doubleAvatar.setVisibility(0);
            this.avatarDouble1.set((ProfileEntity)object.get(0));
            this.avatarDouble2.set((ProfileEntity)object.get(1));
            return;
        }
        if (object.size() > 2) {
            this.tripleAvatar.setVisibility(0);
            this.avatarTriple1.set((ProfileEntity)object.get(0));
            this.avatarTriple2.set((ProfileEntity)object.get(1));
            this.avatarTriple3.set((ProfileEntity)object.get(2));
        }
    }

    public String getChatId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    public void onClick(View view) {
        this.listener.onUserChatClick(this.getChatId());
    }
}

