/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoHolder;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerAdapterContract$Model;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerAdapterContract$View;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import java.util.ArrayList;

class PhotoPickerAdapter
extends RecyclerView.Adapter<PhotoHolder>
implements PhotoPickerAdapterContract$Model,
PhotoPickerAdapterContract$View {
    private BaseActivity activity;
    private OnPhotoClickListener listener;
    private ArrayList<PhotoItem> photoItems;
    private ArrayList<PhotoItem> selectedItems;
    private int itemSize;
    private int itemMargin;

    PhotoPickerAdapter(BaseActivity baseActivity) {
        this.activity = baseActivity;
        this.photoItems = new ArrayList();
        this.selectedItems = new ArrayList();
        this.itemSize = Display.getWidth((Activity)baseActivity) / 3;
        this.itemMargin = (int)Utils.dpToPx((Context)baseActivity, 2.0f);
    }

    @Override
    public void setOnPhotoClickListener(OnPhotoClickListener onPhotoClickListener) {
        this.listener = onPhotoClickListener;
    }

    @Override
    public void notifyDataChanged() {
        this.notifyDataSetChanged();
    }

    public PhotoHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        return new PhotoHolder(LayoutInflater.from((Context)this.activity).inflate(R.layout.ch_plugin_item_photo_picker, viewGroup, false), this.activity.getBackgroundColor(), this.activity.getTextColor(), this.itemSize, this.itemMargin, this.listener);
    }

    public void onBindViewHolder(PhotoHolder photoHolder, int n2) {
        PhotoItem photoItem = this.photoItems.get(n2);
        photoHolder.setValue(photoItem, n2, this.selectedItems.contains(photoItem));
    }

    public int getItemCount() {
        return this.photoItems.size();
    }

    @Override
    public void setPhotoItems(ArrayList<PhotoItem> arrayList) {
        this.photoItems = arrayList;
    }

    @Override
    public void refreshSelectedItems() {
        ArrayList<PhotoItem> arrayList = new ArrayList<PhotoItem>();
        for (PhotoItem photoItem : this.selectedItems) {
            if (this.photoItems.contains(photoItem)) continue;
            arrayList.add(photoItem);
        }
        for (PhotoItem photoItem : arrayList) {
            this.selectedItems.remove(photoItem);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int selectPhotoItem(int n2, boolean bl) {
        PhotoItem photoItem = this.photoItems.get(n2);
        if (!bl) {
            this.selectedItems.remove(photoItem);
            return this.selectedItems.size();
        }
        if (this.selectedItems.size() < 20) {
            if (this.selectedItems.contains(photoItem)) return this.selectedItems.size();
            this.selectedItems.add(photoItem);
            return this.selectedItems.size();
        }
        Toast.makeText((Context)this.activity, (CharSequence)ResUtils.getString((Context)this.activity, "ch.photo.limit_alert"), (int)1).show();
        return -1;
    }

    @Override
    public int getSelectedItemCount() {
        return this.selectedItems.size();
    }

    @Override
    public ArrayList<String> getPhotoPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PhotoItem photoItem : this.selectedItems) {
            arrayList.add(photoItem.getPath());
        }
        return arrayList;
    }
}

