/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity$1;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity$2;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumPagerAdapter;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$OnPhotoTapListener;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import java.util.ArrayList;

public class PhotoAlbumActivity
extends BaseActivity
implements View.OnClickListener,
PhotoViewAttacher$OnPhotoTapListener {
    private static final int ANIMATION_DURATION = 200;
    private View layoutOverlay;
    private String url;
    private String filename;
    private Long size;
    private boolean menuVisible = true;
    private ArrayList<File> files;
    private Animator.AnimatorListener animatorListener = new PhotoAlbumActivity$2(this);

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        Object object;
        Object object2;
        super.onCreate(bundle);
        this.init(R.layout.ch_plugin_activity_photo_album);
        this.setStatusBarColor(-16777216);
        int n2 = -1;
        try {
            this.files = PhotoAlbumStorage.getInstance().getFiles();
            object2 = this.getIntent().getStringExtra("fileId");
            n2 = this.files.indexOf(new File((String)object2));
            object = this.files.get(n2);
            this.url = object.getUrl();
            this.filename = object.getFilename();
            this.size = object.getSize();
        }
        finally {
            if (n2 < 0 || this.url == null || this.filename == null || this.size == 0L) {
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
                this.setResult(-1);
                this.finish();
            }
        }
        this.layoutOverlay = this.findViewById(R.id.layout_image);
        this.findViewById(R.id.button_close_image).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.button_link).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.button_download).setOnClickListener((View.OnClickListener)this);
        object2 = (PhotoViewPager)this.findViewById(R.id.photo_view_pager);
        object = new PhotoAlbumPagerAdapter((Context)this, this.files, this);
        object2.addOnPageChangeListener((ViewPager.OnPageChangeListener)new PhotoAlbumActivity$1(this));
        object2.setAdapter((PagerAdapter)object);
        object2.setCurrentItem(n2);
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (n2 == R.id.button_close_image) {
            this.finish();
        }
        if (n2 == R.id.button_link) {
            this.copyLink();
        }
        if (n2 == R.id.button_download) {
            this.download();
        }
    }

    private void copyLink() {
        try {
            ClipboardManager clipboardManager = (ClipboardManager)this.getSystemService("clipboard");
            ClipData clipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)this.url);
            clipboardManager.setPrimaryClip(clipData);
            UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.url_copied_to_clipboard"));
            return;
        }
        catch (Exception exception) {
            UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
            return;
        }
    }

    private void download() {
        IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", this.url).putExtra("filename", this.filename).putExtra("image", true).startActivity();
    }

    @Override
    public void onPhotoTap(View view, float f2, float f3) {
        this.animateOverlay();
    }

    @Override
    public void onOutsidePhotoTap() {
        this.animateOverlay();
    }

    private void animateOverlay() {
        this.layoutOverlay.animate().alpha(this.menuVisible ? 0.0f : 1.0f).setDuration(200L).setListener(this.animatorListener).start();
    }

    static /* synthetic */ ArrayList access$000(PhotoAlbumActivity photoAlbumActivity) {
        return photoAlbumActivity.files;
    }

    static /* synthetic */ String access$102(PhotoAlbumActivity photoAlbumActivity, String string) {
        photoAlbumActivity.url = string;
        return photoAlbumActivity.url;
    }

    static /* synthetic */ String access$202(PhotoAlbumActivity photoAlbumActivity, String string) {
        photoAlbumActivity.filename = string;
        return photoAlbumActivity.filename;
    }

    static /* synthetic */ Long access$302(PhotoAlbumActivity photoAlbumActivity, Long l2) {
        photoAlbumActivity.size = l2;
        return photoAlbumActivity.size;
    }

    static /* synthetic */ boolean access$402(PhotoAlbumActivity photoAlbumActivity, boolean bl) {
        photoAlbumActivity.menuVisible = bl;
        return photoAlbumActivity.menuVisible;
    }

    static /* synthetic */ boolean access$400(PhotoAlbumActivity photoAlbumActivity) {
        return photoAlbumActivity.menuVisible;
    }

    static /* synthetic */ View access$500(PhotoAlbumActivity photoAlbumActivity) {
        return photoAlbumActivity.layoutOverlay;
    }
}

