/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserInfoMessageHolder$1;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserInfoMessageHolder$2;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserInfoMessageHolder$3;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class UserInfoMessageHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private Context context;
    private LinearLayout inputLayout;
    private LinearLayout completeLayout;
    private TextView title;
    private TextView errorTitle;
    private TextView description;
    private TextView agreement;
    private TextView country;
    private LinearLayout inputLayouts;
    private LinearLayout nameLayout;
    private LinearLayout phoneLayout;
    private LinearLayout countryLayout;
    private WatchedEditText nameEdit;
    private WatchedEditText phoneEdit;
    private Button nameButton;
    private Button phoneButton;
    private CountryDictionary countryDictionary;
    private OnUserInfoListener listener;
    private String code;
    private String mobileNumber;
    private boolean handle = false;

    public UserInfoMessageHolder(View view, OnUserInfoListener onUserInfoListener) {
        super(view);
        this.context = view.getContext();
        this.countryDictionary = new CountryDictionary(view.getContext());
        this.inputLayout = (LinearLayout)view.findViewById(R.id.layout_user_info_input);
        this.completeLayout = (LinearLayout)view.findViewById(R.id.layout_user_info_complete);
        this.title = (TextView)view.findViewById(R.id.user_info_title);
        this.errorTitle = (TextView)view.findViewById(R.id.user_info_error_title);
        this.description = (TextView)view.findViewById(R.id.user_info_description);
        this.agreement = (TextView)view.findViewById(R.id.user_info_agreement);
        this.inputLayouts = (LinearLayout)view.findViewById(R.id.user_info_layout);
        this.nameLayout = (LinearLayout)view.findViewById(R.id.user_info_layout_name);
        this.phoneLayout = (LinearLayout)view.findViewById(R.id.user_info_layout_phone);
        this.nameEdit = (WatchedEditText)view.findViewById(R.id.user_info_layout_name_input);
        this.nameButton = (Button)view.findViewById(R.id.user_info_layout_name_button);
        this.country = (TextView)view.findViewById(R.id.user_info_layout_phone_country);
        this.countryLayout = (LinearLayout)view.findViewById(R.id.user_info_layout_phone_country_layout);
        this.phoneEdit = (WatchedEditText)view.findViewById(R.id.user_info_layout_phone_input);
        this.phoneButton = (Button)view.findViewById(R.id.user_info_layout_phone_button);
        int n2 = ContextCompat.getColor((Context)this.context, (int)R.color.ch_cobalt);
        int n3 = ContextCompat.getColor((Context)this.context, (int)R.color.ch_light);
        this.nameEdit.setHandledButton(this.nameButton, n2, n3);
        this.nameEdit.setWatchedTextChangedListener(new UserInfoMessageHolder$1(this, onUserInfoListener));
        this.phoneEdit.setHandledButton(this.phoneButton, n2, n3);
        this.phoneEdit.setWatchedTextChangedListener(new UserInfoMessageHolder$2(this, onUserInfoListener));
        this.nameButton.setOnClickListener((View.OnClickListener)this);
        this.phoneButton.setOnClickListener((View.OnClickListener)this);
        this.countryLayout.setOnClickListener((View.OnClickListener)this);
        this.agreement.setText((CharSequence)Html.fromHtml((String)ResUtils.getString(this.context, "ch.agreement")));
        this.agreement.setOnClickListener((View.OnClickListener)this);
        this.code = "";
        this.mobileNumber = "";
        this.listener = onUserInfoListener;
    }

    private void initLayout(UserInfoItem userInfoItem) {
        this.title.setVisibility(UIUtils.getVisible(!userInfoItem.isError(), true));
        this.errorTitle.setVisibility(UIUtils.getVisible(userInfoItem.isError(), true));
        this.inputLayout.setVisibility(UIUtils.getVisible(!UserInfoType.COMPLETE.equals((Object)userInfoItem.getUserInfoType()), true));
        this.completeLayout.setVisibility(UIUtils.getVisible(UserInfoType.COMPLETE.equals((Object)userInfoItem.getUserInfoType()), true));
        for (int i2 = 0; i2 < this.inputLayouts.getChildCount(); ++i2) {
            this.inputLayouts.getChildAt(i2).setVisibility(8);
        }
        switch (userInfoItem.getUserInfoType()) {
            case NAME: {
                this.nameLayout.setVisibility(0);
                return;
            }
            case MOBILE_NUMBER: {
                this.phoneLayout.setVisibility(0);
            }
        }
    }

    private String getString(String string) {
        return ResUtils.getString(this.context, string);
    }

    public void set(UserInfoItem userInfoItem) {
        this.initLayout(userInfoItem);
        this.setAgreementVisibility();
        this.handle = true;
        switch (userInfoItem.getUserInfoType()) {
            case NAME: {
                if (userInfoItem.getObject() != null && userInfoItem.getObject() instanceof String) {
                    String string = (String)userInfoItem.getObject();
                    this.nameEdit.setText(string);
                }
                if (userInfoItem.isError()) {
                    this.errorTitle.setText((CharSequence)this.getString("ch.name_verification.title"));
                    this.description.setText((CharSequence)this.getString("ch.name_verification.description"));
                    this.nameEdit.selectAll();
                    return;
                }
                this.title.setText((CharSequence)this.getString("ch.name_verification.title"));
                this.description.setText((CharSequence)this.getString("ch.name_verification.description"));
                return;
            }
            case MOBILE_NUMBER: {
                if (userInfoItem.getObject() != null && userInfoItem.getObject() instanceof MobileNumberItem) {
                    MobileNumberItem mobileNumberItem = (MobileNumberItem)userInfoItem.getObject();
                    this.code = mobileNumberItem.getCountry();
                    this.mobileNumber = mobileNumberItem.getMobileNumber();
                    this.country.setText((CharSequence)String.format("+%s", mobileNumberItem.getCountry()));
                    this.phoneEdit.setText(mobileNumberItem.getMobileNumber());
                }
                if (userInfoItem.isError()) {
                    this.errorTitle.setText((CharSequence)this.getString("ch.mobile_verification.error.title"));
                    this.description.setText((CharSequence)this.getString("ch.mobile_verification.error.description"));
                    this.phoneEdit.selectAll();
                    return;
                }
                this.title.setText((CharSequence)this.getString("ch.mobile_verification.title"));
                this.description.setText((CharSequence)this.getString("ch.mobile_verification.description"));
            }
        }
    }

    private void showCountryDialog() {
        Object object = new ArrayAdapter(this.context, 0x1090011);
        object.addAll(this.countryDictionary.getCountryNames());
        object = new AlertDialog.Builder(this.context).setCancelable(true).setAdapter((ListAdapter)object, (DialogInterface.OnClickListener)new UserInfoMessageHolder$3(this));
        try {
            object.show();
            return;
        }
        catch (Exception exception) {
            object = exception;
            L.e(exception.getMessage());
            return;
        }
    }

    private void countrySelected(String string) {
        this.country.setText((CharSequence)String.format("+%s", string));
        this.code = string;
        if (this.listener != null && this.handle) {
            this.listener.userInfoChanged(new MobileNumberItem(string, this.mobileNumber));
        }
    }

    private void setAgreementVisibility() {
        Channel channel = ChannelStore.getChannel();
        if (channel != null && channel.getCountry().equalsIgnoreCase("kr")) {
            this.agreement.setVisibility(0);
            return;
        }
        this.agreement.setVisibility(8);
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (n2 == R.id.user_info_layout_phone_country_layout) {
            this.showCountryDialog();
        }
        if ((n2 == R.id.user_info_layout_name_button || n2 == R.id.user_info_layout_phone_button) && this.listener != null && this.handle) {
            this.listener.sendUserInfo();
        }
        if (n2 == R.id.user_info_agreement) {
            String string = "http://channel.io/ko/terms_user?channel=" + (ChannelStore.getChannel() != null ? ChannelStore.getChannel().getName() : "");
            Executor.goWeb(this.context, string);
        }
    }

    static /* synthetic */ boolean access$000(UserInfoMessageHolder userInfoMessageHolder) {
        return userInfoMessageHolder.handle;
    }

    static /* synthetic */ String access$100(UserInfoMessageHolder userInfoMessageHolder) {
        return userInfoMessageHolder.code;
    }

    static /* synthetic */ String access$202(UserInfoMessageHolder userInfoMessageHolder, String string) {
        userInfoMessageHolder.mobileNumber = string;
        return userInfoMessageHolder.mobileNumber;
    }

    static /* synthetic */ CountryDictionary access$300(UserInfoMessageHolder userInfoMessageHolder) {
        return userInfoMessageHolder.countryDictionary;
    }

    static /* synthetic */ void access$400(UserInfoMessageHolder userInfoMessageHolder, String string) {
        userInfoMessageHolder.countrySelected(string);
    }
}

