/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.Logger;
import com.splunk.mint.Properties$RemoteSettingsProps;
import com.splunk.mint.RemoteSettingsData;
import org.json.JSONObject;

class RemoteSettings {
    private static final String SHARED_PREFERENSES_NAME = "REMOTESETTINGSSETTINGS";
    private static final String REMOTESETTINGS_API = "1";
    private static final String REMOTESETTINGS_NAME = "remSetVer";
    private static final String LOGLEVEL = "logLevel";
    private static final String EVENTLEVEL = "eventLevel";
    private static final String NETWORKMONITORING = "netMonitoring";
    private static final String SESSIONTIME = "sessionTime";
    private static final String HASHCODE = "hashCode";
    private static final String DEVSETTINGS = "devSettings";

    RemoteSettings() {
    }

    protected static final RemoteSettingsData convertJsonToRemoteSettings(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        RemoteSettingsData remoteSettingsData = new RemoteSettingsData();
        try {
            string = new JSONObject(string);
            string = string.optJSONObject("remSetVer1");
            if (string != null) {
                remoteSettingsData.logLevel = string.optInt(LOGLEVEL);
                remoteSettingsData.eventLevel = string.optInt(EVENTLEVEL);
                remoteSettingsData.netMonitoring = string.optBoolean(NETWORKMONITORING);
                remoteSettingsData.sessionTime = string.optInt(SESSIONTIME);
                if (string.optJSONObject(DEVSETTINGS) != null) {
                    remoteSettingsData.devSettings = string.optJSONObject(DEVSETTINGS).toString();
                }
                remoteSettingsData.hashCode = string.optString("hash");
            }
        }
        catch (Exception exception) {
            Logger.logError("Could not convert json to remote data");
            Logger.logInfo(exception.getMessage());
            return null;
        }
        return remoteSettingsData;
    }

    protected static final void saveAndLoadRemoteSettings(Context context, RemoteSettingsData remoteSettingsData) {
        if ((context = context.getSharedPreferences(SHARED_PREFERENSES_NAME, 0)) == null) {
            return;
        }
        if ((context = context.edit()) == null) {
            return;
        }
        try {
            if (remoteSettingsData.logLevel != null && remoteSettingsData.logLevel > 0) {
                context.putInt(LOGLEVEL, remoteSettingsData.logLevel.intValue());
                Properties$RemoteSettingsProps.logLevel = remoteSettingsData.logLevel;
            }
            if (remoteSettingsData.eventLevel != null && remoteSettingsData.eventLevel > 0) {
                context.putInt(EVENTLEVEL, remoteSettingsData.eventLevel.intValue());
                Properties$RemoteSettingsProps.eventLevel = remoteSettingsData.eventLevel;
            }
            if (remoteSettingsData.netMonitoring != null) {
                context.putBoolean(NETWORKMONITORING, remoteSettingsData.netMonitoring.booleanValue());
                Properties$RemoteSettingsProps.netMonitoringEnabled = remoteSettingsData.netMonitoring;
            }
            if (remoteSettingsData.sessionTime != null && remoteSettingsData.sessionTime > 0) {
                context.putInt(SESSIONTIME, remoteSettingsData.sessionTime.intValue());
                Properties$RemoteSettingsProps.sessionTime = remoteSettingsData.sessionTime;
            }
            if (remoteSettingsData.devSettings != null) {
                context.putString(DEVSETTINGS, remoteSettingsData.devSettings);
                Properties$RemoteSettingsProps.devSettings = new JSONObject(remoteSettingsData.devSettings);
            }
            if (remoteSettingsData.hashCode != null && remoteSettingsData.hashCode.length() > 1) {
                context.putString(HASHCODE, remoteSettingsData.hashCode);
                Properties$RemoteSettingsProps.hashCode = remoteSettingsData.hashCode;
            }
        }
        catch (Exception exception) {
            Logger.logError("Could not save remote data");
            Logger.logInfo(exception.getMessage());
        }
        context.apply();
    }

    protected static final RemoteSettingsData loadRemoteSettings(Context context) {
        RemoteSettingsData remoteSettingsData = new RemoteSettingsData();
        if ((context = context.getSharedPreferences(SHARED_PREFERENSES_NAME, 0)) == null) {
            return null;
        }
        remoteSettingsData.logLevel = context.getInt(LOGLEVEL, Properties$RemoteSettingsProps.logLevel.intValue());
        if (remoteSettingsData.logLevel == null) {
            remoteSettingsData.logLevel = Properties$RemoteSettingsProps.logLevel;
        }
        remoteSettingsData.eventLevel = context.getInt(EVENTLEVEL, Properties$RemoteSettingsProps.eventLevel.intValue());
        if (remoteSettingsData.eventLevel == null) {
            remoteSettingsData.eventLevel = Properties$RemoteSettingsProps.eventLevel;
        }
        remoteSettingsData.netMonitoring = context.getBoolean(NETWORKMONITORING, Properties$RemoteSettingsProps.netMonitoringEnabled.booleanValue());
        if (remoteSettingsData.netMonitoring == null) {
            remoteSettingsData.netMonitoring = Properties$RemoteSettingsProps.netMonitoringEnabled;
        }
        remoteSettingsData.sessionTime = context.getInt(SESSIONTIME, Properties$RemoteSettingsProps.sessionTime.intValue());
        if (remoteSettingsData.sessionTime == null) {
            remoteSettingsData.sessionTime = Properties$RemoteSettingsProps.sessionTime;
        }
        remoteSettingsData.devSettings = context.getString(DEVSETTINGS, Properties$RemoteSettingsProps.devSettings.toString());
        if (remoteSettingsData.devSettings == null) {
            remoteSettingsData.devSettings = Properties$RemoteSettingsProps.devSettings.toString();
        }
        remoteSettingsData.hashCode = context.getString(HASHCODE, Properties$RemoteSettingsProps.hashCode);
        if (remoteSettingsData.hashCode == null) {
            remoteSettingsData.hashCode = Properties$RemoteSettingsProps.hashCode;
        }
        return remoteSettingsData;
    }
}

