package com.zoyi.channel.plugin.android.util;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;

public class ProgressHelper {

  public static ProgressDialog show(Context context, int messageResId) {
    return show(context, context.getString(messageResId), true);
  }

  public static ProgressDialog show(Context context, int messageResId, boolean cancelable) {
    return show(context, context.getString(messageResId), cancelable);
  }

  public static ProgressDialog show(Context context, String message) {
    return show(context, message, true);
  }

  private static ProgressDialog show(Context context, String message, boolean cancelable) {
    ProgressDialog dialog = new ProgressDialog(context);

    dialog.setTitle("");
    dialog.setMessage(message);
    dialog.setCancelable(cancelable);
    dialog.show();

    if (cancelable) {
      dialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
        @Override
        public boolean onKey(final DialogInterface dialog, int keyCode, KeyEvent keyEvent) {
          if (keyCode == KeyEvent.KEYCODE_BACK) {
            dialog.dismiss();
            return true;
          }
          return false;
        }
      });
    }
    return dialog;
  }

}
