package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;

/**
 * Created by mika on 2016. 12. 9..
 */
public class UserMessageHolder extends ChatMessageHolder {
  View headBubble, contextBubble;

  public UserMessageHolder(
      View itemView,
      OnMessageClickListener listener,
      int backColor,
      int textColor) {
    super(itemView, listener);

    headBubble = itemView.findViewById(R.id.message_head_color);
    contextBubble = itemView.findViewById(R.id.message_context_color);

    headBubble.setBackgroundColor(backColor);
    contextBubble.setBackgroundColor(backColor);
    text.setBackgroundColor(backColor);
    text.setTextColor(textColor);
  }
}
