package com.zoyi.channel.plugin.android.activity.base;

import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.UpdatedModel;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.Collections;
import java.util.List;

/**
 * Created by mika on 2016. 12. 20..
 */
public abstract class BaseDictionary {
  protected abstract  <E extends ChannelModel> E get(Class<E> clazz, String id);
  protected abstract void add(List<? extends ChannelModel> channelModels);
  protected abstract void remove(ChannelModel channelModel);

  public void add(ChannelModel channelModel) {
    add(Collections.singletonList(channelModel));
  }

  protected boolean checkCanUpdate(ChannelModel channelModel) {
    if (channelModel instanceof UpdatedModel) {
      ChannelModel model = get(channelModel.getClass(), channelModel.getId());
      if (model == null) {
        return true;
      } else if (model instanceof UpdatedModel) {
        UpdatedModel oldbie = (UpdatedModel) model;
        UpdatedModel newbie = (UpdatedModel) channelModel;

        return CompareUtils.compare(oldbie.getUpdatedAt(), newbie.getUpdatedAt()) < 0;
      }
    }
    return true;
  }
}
