package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.content.SharedPreferences;

import com.zoyi.channel.plugin.android.CheckIn;

import java.util.Map;

public class CheckInPrefSupervisor {

  private static final String CHECK_IN_PREF = "CheckInPreferences";

  private static final String HAS_CHECK_IN_DATA = "hasCheckInData";
  private static final String USER_ID = "userId";
  private static final String NAME = "name";
  private static final String AVATAR_URL = "avatarUrl";
  private static final String MOBILE_NUMBER = "mobileNumber";

  public static void set(Context context, CheckIn checkIn) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    SharedPreferences.Editor editor = preferences.edit();

    editor.putBoolean(HAS_CHECK_IN_DATA, true);

    if (checkIn != null) {
      editor.putString(USER_ID, checkIn.getUserId());
      editor.putString(NAME, checkIn.getName());
      editor.putString(AVATAR_URL, checkIn.getAvatarUrl());
      editor.putString(MOBILE_NUMBER, checkIn.getMobileNumber());

      Map<String, Object> meta = checkIn.getMapMeta();

      for (Map.Entry<String, ?> entry : meta.entrySet()) {
        Object value = entry.getValue();

        if (value != null) {
          if (value instanceof String) {
            editor.putString(entry.getKey(), String.valueOf(value));
          } else if (value instanceof Integer) {
            editor.putInt(entry.getKey(), (Integer) value);
          } else if (value instanceof Long) {
            editor.putLong(entry.getKey(), (Long) value);
          } else if (value instanceof Boolean) {
            editor.putBoolean(entry.getKey(), (Boolean) value);
          }
        }
      }
    }
    editor.apply();
  }

  public static CheckIn get(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    CheckIn checkIn = new CheckIn();
    Map<String, ?> datas = preferences.getAll();

    for (Map.Entry<String, ?> entry : datas.entrySet()) {
      if (USER_ID.equals(entry.getKey())) {
        checkIn.withUserId(String.valueOf(entry.getValue()));
      } else if (NAME.equals(entry.getKey())) {
        checkIn.withName(String.valueOf(entry.getValue()));
      } else if (AVATAR_URL.equals(entry.getKey())) {
        checkIn.withAvatarUrl(String.valueOf(entry.getValue()));
      } else if (MOBILE_NUMBER.equals(entry.getKey())) {
        checkIn.withMobileNumber(String.valueOf(entry.getValue()));
      } else {
        Object value = entry.getValue();

        if (value instanceof String) {
          checkIn.withMeta(entry.getKey(), String.valueOf(value));
        } else if (value instanceof Integer) {
          checkIn.withMeta(entry.getKey(), (Integer) value);
        } else if (value instanceof Long) {
          checkIn.withMeta(entry.getKey(), (Long) value);
        } else if (value instanceof Boolean) {
          if (!entry.getKey().equals(HAS_CHECK_IN_DATA)) {
            checkIn.withMeta(entry.getKey(), (Boolean) value);
          }
        }
      }
    }
    return checkIn;
  }

  public static boolean hasCheckInData(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);

    return preferences.getBoolean(HAS_CHECK_IN_DATA, false);
  }

  public static void clear(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    SharedPreferences.Editor editor = preferences.edit();

    editor.clear();
    editor.apply();
  }

}
