/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;

public class WatchedEditText
extends EditText {
    private EditTextChangedListener listener;
    private boolean block = false;
    private Button button;
    private int activeColor;
    private int deactiveColor;

    public WatchedEditText(Context context) {
        super(context);
    }

    public WatchedEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public WatchedEditText(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    public void setWatchedTextChangedListener(EditTextChangedListener editTextChangedListener) {
        this.listener = editTextChangedListener;
        this.listener.onWatchedTextChanged(this.getText().toString());
    }

    public void setHandledButton(Button button, int n2, int n3) {
        this.button = button;
        this.activeColor = n2;
        this.deactiveColor = n3;
        this.setButtonStyle(this.getString());
    }

    protected void onSelectionChanged(int n2, int n3) {
        super.onSelectionChanged(n2, n3);
    }

    protected void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
        super.onTextChanged(charSequence, n2, n3, n4);
        if (this.listener != null && !this.block) {
            this.listener.onWatchedTextChanged(charSequence.toString());
        }
        this.setButtonStyle(charSequence.toString());
    }

    private void setButtonStyle(String string2) {
        if (this.button != null) {
            if ("".equals(StringUtils.stripEnd(string2, null))) {
                this.button.setEnabled(false);
                this.button.setTextColor(this.deactiveColor);
                return;
            }
            this.button.setEnabled(true);
            this.button.setTextColor(this.activeColor);
        }
    }

    public void setTextWithBlock(String string2) {
        this.block = true;
        this.setText(string2);
    }

    public void setBlock(boolean bl) {
        this.block = bl;
    }

    public String getString() {
        return this.getText().toString();
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getString());
    }
}

