/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.socket;

import android.app.Application;
import com.zoyi.a.a.b.ae;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ReferMessage;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.socket.a;
import com.zoyi.channel.plugin.android.socket.b;
import com.zoyi.channel.plugin.android.socket.c;
import com.zoyi.channel.plugin.android.socket.d;
import com.zoyi.channel.plugin.android.socket.e;
import com.zoyi.channel.plugin.android.socket.f;
import com.zoyi.channel.plugin.android.socket.g;
import com.zoyi.channel.plugin.android.socket.h;
import com.zoyi.channel.plugin.android.socket.i;
import com.zoyi.channel.plugin.android.socket.j;
import com.zoyi.channel.plugin.android.socket.k;
import com.zoyi.channel.plugin.android.socket.l;
import com.zoyi.channel.plugin.android.socket.m;
import com.zoyi.channel.plugin.android.socket.n;
import com.zoyi.channel.plugin.android.socket.o;
import com.zoyi.channel.plugin.android.socket.p;
import com.zoyi.channel.plugin.android.socket.q;
import com.zoyi.channel.plugin.android.socket.r;
import com.zoyi.channel.plugin.android.socket.s;
import com.zoyi.channel.plugin.android.socket.t;
import com.zoyi.channel.plugin.android.socket.u;
import com.zoyi.channel.plugin.android.socket.v;
import com.zoyi.channel.plugin.android.socket.w;
import com.zoyi.channel.plugin.android.socket.x;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.ab;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketManager {
    private static SocketManager socketManager;
    private Application application;
    private ae socket;
    private com.zoyi.com.google.gson.i gson;
    private Timer heartbeatTimer;
    private Timer reconnectConsumer;
    private AtomicBoolean forceDisconnect;
    private AtomicBoolean ready;
    private AtomicBoolean error;
    private ab heartbeat;
    private BlockingQueue<Integer> reconnectQueue;
    private int[] attemptDelay = new int[]{100, 3000, 4000, 5000, 7000, 8000, 10000};
    private AtomicInteger attemptCount = new AtomicInteger();
    private static final int HEARTBEAT_INTERVAL = 30000;
    private static final int RECONNECT_POP_INTERVAL = 500;
    private static final String CHAT_SERVER_URL_PRODUCTION = "https://ws.channel.io/app";
    private String channelId;
    private com.zoyi.a.a.c.b onConnect = new r(this);
    private com.zoyi.a.a.c.b onConnectTimeout = new s(this);
    private com.zoyi.a.a.c.b onConnectError = new t(this);
    private com.zoyi.a.a.c.b onConnecting = new u(this);
    private com.zoyi.a.a.c.b onDisconnect = new v(this);
    private com.zoyi.a.a.c.b onError = new w(this);
    private com.zoyi.a.a.c.b onPing = new x(this);
    private com.zoyi.a.a.c.b onPong = new b(this);
    private com.zoyi.a.a.c.b onReconnect = new c(this);
    private com.zoyi.a.a.c.b onReconnectAttempt = new d(this);
    private com.zoyi.a.a.c.b onReconnectError = new e(this);
    private com.zoyi.a.a.c.b onReconnectFailed = new f(this);
    private com.zoyi.a.a.c.b onReconnecting = new g(this);
    private com.zoyi.a.a.c.b onAuthenticated = new h(this);
    private com.zoyi.a.a.c.b onReady = new i(this);
    private com.zoyi.a.a.c.b onJoined = new j(this);
    private com.zoyi.a.a.c.b onLeaved = new k(this);
    private com.zoyi.a.a.c.b onUnauthorized = new m(this);
    private com.zoyi.a.a.c.b onPush = new n(this);
    private com.zoyi.a.a.c.b onCreate = new o(this);
    private com.zoyi.a.a.c.b onUpdate = new p(this);
    private com.zoyi.a.a.c.b onDelete = new q(this);

    public static void create(Application application) {
        if (socketManager == null) {
            socketManager = new SocketManager();
            new SocketManager().application = application;
            socketManager.init();
        }
    }

    private void init() {
        this.gson = new com.zoyi.com.google.gson.i();
        this.forceDisconnect = new AtomicBoolean(false);
        this.ready = new AtomicBoolean(false);
        this.error = new AtomicBoolean(false);
        this.reconnectQueue = new ArrayBlockingQueue<Integer>(1);
        try {
            com.zoyi.a.a.b.c c2 = new com.zoyi.a.a.b.c();
            new com.zoyi.a.a.b.c().b = false;
            c2.d = new String[]{"websocket"};
            this.socket = com.zoyi.a.a.b.b.a(CHAT_SERVER_URL_PRODUCTION, c2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        this.socket.a("connect", this.onConnect);
        this.socket.a("connect_error", this.onConnectError);
        this.socket.a("connect_timeout", this.onConnectTimeout);
        this.socket.a("connecting", this.onConnecting);
        this.socket.a("disconnect", this.onDisconnect);
        this.socket.a("error", this.onError);
        this.socket.a("ping", this.onPing);
        this.socket.a("pong", this.onPong);
        this.socket.a("reconnect", this.onReconnect);
        this.socket.a("reconnect_attempt", this.onReconnectAttempt);
        this.socket.a("reconnect_error", this.onReconnectError);
        this.socket.a("reconnect_failed", this.onReconnectFailed);
        this.socket.a("reconnecting", this.onReconnecting);
        this.socket.a("authenticated", this.onAuthenticated);
        this.socket.a("ready", this.onReady);
        this.socket.a("create", this.onCreate);
        this.socket.a("delete", this.onDelete);
        this.socket.a("joined", this.onJoined);
        this.socket.a("leaved", this.onLeaved);
        this.socket.a("push", this.onPush);
        this.socket.a("unauthorized", this.onUnauthorized);
        this.socket.a("update", this.onUpdate);
    }

    public static void setChannelId(String string2) {
        if (socketManager != null) {
            SocketManager.socketManager.channelId = string2;
        }
    }

    public static boolean isReady() {
        if (socketManager != null) {
            return SocketManager.socketManager.ready.get();
        }
        return false;
    }

    public static boolean isError() {
        if (socketManager != null) {
            return SocketManager.socketManager.error.get();
        }
        return false;
    }

    public static void connect() {
        if (socketManager != null) {
            socketManager.connectSocket();
        }
    }

    public static void reconnect() {
        if (socketManager != null && ChannelStore.isMainRunning()) {
            socketManager.enqueueReconnect();
        }
    }

    public static void joinChat(String string2) {
        if (socketManager != null) {
            socketManager.chatAction("join", string2);
        }
    }

    public static void leaveChat(String string2) {
        if (socketManager != null) {
            socketManager.chatAction("leave", string2);
        }
    }

    public static void disconnect() {
        if (socketManager != null) {
            socketManager.disconnect(true);
            socketManager.stopHeartbeat();
        }
    }

    public static void destroy() {
        if (socketManager != null) {
            socketManager.setReconnectConsumer(false);
            SocketManager.socketManager.socket.e();
            SocketManager.socketManager.socket.b();
            SocketManager.socketManager.channelId = null;
            SocketManager.socketManager.forceDisconnect = null;
            SocketManager.socketManager.ready = null;
            SocketManager.socketManager.reconnectQueue = null;
            SocketManager.socketManager.socket = null;
            SocketManager.socketManager.gson = null;
            socketManager = null;
        }
    }

    private void enqueueReconnect() {
        if (!this.ready.get()) {
            try {
                this.reconnectQueue.add(1);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private void clearReconnectQueue() {
        try {
            this.reconnectQueue.clear();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void connectSocket() {
        if (this.socket != null && !this.socket.c() && this.channelId != null) {
            L.d("try connect");
            ae ae2 = this.socket;
            ae2.a();
            this.setReconnectConsumer(true);
        }
    }

    private void disconnect(boolean bl) {
        this.forceDisconnect.set(bl);
        try {
            this.clearReconnectQueue();
            this.socket.b();
        }
        catch (Exception exception) {}
        if (!bl) {
            this.enqueueReconnect();
            return;
        }
        this.setReconnectConsumer(false);
    }

    private void authentication() {
        Object object = ChannelStore.getPersonType();
        String string2 = ChannelStore.getPersonId();
        if (object != null && string2 != null && this.channelId != null) {
            object = String.format("{\n  type: \"Plugin\",\n  channelId: \"%s\",\n  guestType: \"%s\",\n  guestId: \"%s\"}", this.channelId, object, string2);
            try {
                object = new JSONObject(object);
                this.emit("authentication", object);
            }
            catch (JSONException jSONException) {
                object = jSONException;
                jSONException.printStackTrace();
                RxBus.post(new CommandBus(Command.UNAUTHORIZED));
                return;
            }
        } else {
            this.disconnect(true);
        }
    }

    private synchronized void setReconnectConsumer(boolean bl) {
        if (bl) {
            if (this.reconnectConsumer == null) {
                this.reconnectConsumer = new Timer();
                this.reconnectConsumer.schedule((TimerTask)new a(this), 500L, 500L);
                return;
            }
        } else if (this.reconnectConsumer != null) {
            try {
                this.reconnectConsumer.cancel();
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                this.reconnectConsumer = null;
            }
        }
    }

    private void startHeartbeat() {
        this.stopHeartbeat();
        this.heartbeat = com.zoyi.rx.q.a(30000L, TimeUnit.MILLISECONDS).b(new l(this));
    }

    private void stopHeartbeat() {
        if (this.heartbeat != null && !this.heartbeat.isUnsubscribed()) {
            this.heartbeat.unsubscribe();
            this.heartbeat = null;
        }
    }

    private void emit(String string2, Object object) {
        if (object == null || this.socket == null) {
            return;
        }
        this.socket.a(string2, object);
    }

    private void chatAction(String string2, String string3) {
        if (this.socket == null) {
            return;
        }
        if (string3 == null || !this.ready.get()) {
            return;
        }
        string3 = String.format("/user_chats/%s", string3);
        this.emit(string2, string3);
    }

    private String getTag(JSONObject object) {
        try {
            String string2 = object.getString("type");
            object = object.getJSONObject("entity").getString("id");
            return String.format("%s (%s): ", string2, object);
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onMessage(JSONObject object, boolean bl) {
        try {
            if (!object.has("type") || !object.has("entity")) {
                return;
            }
            Object object2 = object.getString("entity");
            switch (object.getString("type")) {
                case "Manager": {
                    void var2_12;
                    Manager manager = this.parseJson((String)object2, Manager.class);
                    if (manager == null) {
                        return;
                    }
                    RxBus.post(new ChannelModelBus(manager, (boolean)var2_12));
                    return;
                }
                case "Message": {
                    Object object3;
                    void var2_12;
                    object2 = this.parseJson((String)object2, Message.class);
                    if (object2 == null) {
                        return;
                    }
                    if (object.has("refers")) {
                        object3 = object.getJSONObject("refers");
                        if (object3.has("file")) {
                            File file = this.parseJson(object3.getString("file"), File.class);
                            RxBus.post(new ChannelModelBus(file, (boolean)var2_12));
                        }
                        if (object3.has("webPage")) {
                            WebPage webPage = this.parseJson(object3.getString("webPage"), WebPage.class);
                            RxBus.post(new ChannelModelBus(webPage, (boolean)var2_12));
                        }
                        if (object3.has("bot")) {
                            Bot bot = this.parseJson(object3.getString("bot"), Bot.class);
                            RxBus.post(new ChannelModelBus(bot, (boolean)var2_12));
                        }
                    }
                    RxBus.post(new ChannelModelBus((ChannelModel)object2, (boolean)var2_12));
                    return;
                }
                case "UserChat": {
                    void var2_12;
                    Object object3 = this.parseJson((String)object2, UserChat.class);
                    if (object3 == null) {
                        return;
                    }
                    if (object.has("refers")) {
                        JSONObject jSONObject = object.getJSONObject("refers");
                        if (jSONObject.has("message")) {
                            ReferMessage referMessage = this.parseJson(jSONObject.getString("message"), ReferMessage.class);
                            RxBus.post(new ChannelModelBus(referMessage, (boolean)var2_12));
                        }
                        if (jSONObject.has("manager")) {
                            Manager manager = this.parseJson(jSONObject.getString("manager"), Manager.class);
                            RxBus.post(new ChannelModelBus(manager, (boolean)var2_12));
                        }
                        if (jSONObject.has("bot")) {
                            Bot bot = this.parseJson(jSONObject.getString("bot"), Bot.class);
                            RxBus.post(new ChannelModelBus(bot, (boolean)var2_12));
                        }
                    }
                    RxBus.post(new ChannelModelBus((ChannelModel)object3, (boolean)var2_12));
                    return;
                }
                case "Session": {
                    void var2_12;
                    Session session = this.parseJson((String)object2, Session.class);
                    if (session == null) {
                        return;
                    }
                    if (object.has("refers")) {
                        JSONObject jSONObject = object.getJSONObject("refers");
                        if (jSONObject.has("bot")) {
                            object2 = this.parseJson(jSONObject.getString("bot"), Bot.class);
                            RxBus.post(new ChannelModelBus((ChannelModel)object2, (boolean)var2_12));
                        }
                        if (jSONObject.has("manager")) {
                            object2 = this.parseJson(jSONObject.getString("manager"), Manager.class);
                            RxBus.post(new ChannelModelBus((ChannelModel)object2, (boolean)var2_12));
                        }
                    }
                    RxBus.post(new ChannelModelBus(session, (boolean)var2_12));
                    return;
                }
                case "File": {
                    void var2_12;
                    File file = this.parseJson((String)object2, File.class);
                    if (file == null) return;
                    RxBus.post(new ChannelModelBus(file, (boolean)var2_12));
                    return;
                }
                case "Channel": {
                    void var2_12;
                    object2 = this.parseJson((String)object2, Channel.class);
                    if (object2 == null) return;
                    RxBus.post(new ChannelModelBus((ChannelModel)object2, (boolean)var2_12));
                    return;
                }
                case "Veil": {
                    Veil veil = this.parseJson((String)object2, Veil.class);
                    if (veil == null) return;
                    ChannelStore.setUserVeil(null, veil);
                    return;
                }
                case "User": {
                    User user = this.parseJson((String)object2, User.class);
                    if (user == null) return;
                    ChannelStore.setUserVeil(user, null);
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            L.e(exception.getMessage());
        }
    }

    private <T> T parseJson(String object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        try {
            return this.gson.a((String)object, clazz);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ BlockingQueue access$000(SocketManager socketManager) {
        return socketManager.reconnectQueue;
    }

    static /* synthetic */ AtomicInteger access$100(SocketManager socketManager) {
        return socketManager.attemptCount;
    }

    static /* synthetic */ int[] access$200(SocketManager socketManager) {
        return socketManager.attemptDelay;
    }

    static /* synthetic */ void access$300(SocketManager socketManager) {
        socketManager.connectSocket();
    }

    static /* synthetic */ ae access$400(SocketManager socketManager) {
        return socketManager.socket;
    }

    static /* synthetic */ AtomicBoolean access$500(SocketManager socketManager) {
        return socketManager.error;
    }

    static /* synthetic */ AtomicBoolean access$600(SocketManager socketManager) {
        return socketManager.forceDisconnect;
    }

    static /* synthetic */ void access$700(SocketManager socketManager) {
        socketManager.authentication();
    }

    static /* synthetic */ AtomicBoolean access$800(SocketManager socketManager) {
        return socketManager.ready;
    }

    static /* synthetic */ void access$900(SocketManager socketManager) {
        socketManager.enqueueReconnect();
    }

    static /* synthetic */ void access$1000(SocketManager socketManager) {
        socketManager.stopHeartbeat();
    }

    static /* synthetic */ void access$1100(SocketManager socketManager) {
        socketManager.startHeartbeat();
    }

    static /* synthetic */ void access$1200(SocketManager socketManager) {
        socketManager.clearReconnectQueue();
    }

    static /* synthetic */ Object access$1300(SocketManager socketManager, String string2, Class clazz) {
        return socketManager.parseJson(string2, clazz);
    }

    static /* synthetic */ Application access$1400(SocketManager socketManager) {
        return socketManager.application;
    }

    static /* synthetic */ String access$1500(SocketManager socketManager, JSONObject jSONObject) {
        return socketManager.getTag(jSONObject);
    }

    static /* synthetic */ void access$1600(SocketManager socketManager, JSONObject jSONObject, boolean bl) {
        socketManager.onMessage(jSONObject, bl);
    }
}

