/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class ChatMessageItem
implements MessageItem {
    private Message message;
    private MessageType type;

    public ChatMessageItem() {
    }

    public ChatMessageItem(Message message) {
        this.message = message;
        if (this.message != null && "Manager".equals(message.getPersonType())) {
            this.type = MessageType.MANAGER_MESSAGE;
            return;
        }
        this.type = MessageType.USER_MESSAGE;
    }

    @Override
    public Long getFirst() {
        switch (this.type) {
            case MANAGER_MESSAGE: 
            case USER_MESSAGE: {
                return this.message.getCreatedAt();
            }
        }
        return 0L;
    }

    @Override
    public String getSecond() {
        switch (this.type) {
            case MANAGER_MESSAGE: 
            case USER_MESSAGE: {
                return this.message.getId();
            }
        }
        return "";
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    public boolean isConnected(MessageItem object) {
        if (object == null || !(object instanceof ChatMessageItem)) {
            return false;
        }
        if (this.getType() != object.getType()) {
            return false;
        }
        Object object2 = this.message;
        object = ((ChatMessageItem)object).getMessage();
        if (this.getType() == MessageType.MANAGER_MESSAGE) {
            if (object2 == null || object == null) {
                return false;
            }
            if (CompareUtils.compare(((Message)object2).getPersonId(), ((Message)object).getPersonId()) != 0) {
                return false;
            }
        }
        switch (this.getType()) {
            case MANAGER_MESSAGE: 
            case USER_MESSAGE: {
                object2 = TimeUtils.get(TimeUtils.MINUTE_24, ((Message)object2).getCreatedAt());
                object = TimeUtils.get(TimeUtils.MINUTE_24, ((Message)object).getCreatedAt());
                return CompareUtils.compare((String)object2, (String)object) == 0;
            }
        }
        return false;
    }

    public String getPersonType() {
        if (this.message != null) {
            return this.message.getPersonType();
        }
        return null;
    }

    public String getPersonId() {
        if (this.message != null) {
            return this.message.getPersonId();
        }
        return null;
    }
}

