/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import com.splunk.mint.ActionMemoryTrim;
import com.splunk.mint.ForegroundHandler;
import java.text.DecimalFormat;
import java.text.NumberFormat;

class MemoryTrimHandler
implements ComponentCallbacks2 {
    private static MemoryTrimHandler handler = new MemoryTrimHandler();

    private MemoryTrimHandler() {
    }

    public static void initialize(Application application) {
        try {
            application.unregisterComponentCallbacks((ComponentCallbacks)handler);
        }
        catch (Exception exception) {}
        application.registerComponentCallbacks((ComponentCallbacks)handler);
    }

    public void onTrimMemory(int n2) {
        try {
            if (n2 == 20) {
                ForegroundHandler.applicationMovedToBackground();
            }
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
            int n3 = runningAppProcessInfo.lastTrimLevel;
            Object object = new DecimalFormat("#.##");
            Runtime runtime = Runtime.getRuntime();
            object = String.valueOf(((NumberFormat)object).format((double)runtime.totalMemory() / 1024.0 / 1024.0));
            ActionMemoryTrim.createMemoryTrim(this.getLevel(n2), this.getLevel(n3), (String)object).save();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    String getLevel(int n2) {
        String string = "NA";
        switch (n2) {
            case 40: {
                string = "TRIM_MEMORY_BACKGROUND";
                break;
            }
            case 80: {
                string = "TRIM_MEMORY_COMPLETE";
                break;
            }
            case 60: {
                string = "TRIM_MEMORY_MODERATE";
                break;
            }
            case 15: {
                string = "TRIM_MEMORY_RUNNING_CRITICAL";
                break;
            }
            case 10: {
                string = "TRIM_MEMORY_RUNNING_LOW";
                break;
            }
            case 5: {
                string = "TRIM_MEMORY_RUNNING_MODERATE";
                break;
            }
            case 20: {
                string = "TRIM_MEMORY_UI_HIDDEN";
            }
        }
        return string;
    }

    public void onLowMemory() {
    }

    public void onConfigurationChanged(Configuration configuration) {
    }
}

