package com.zoyi.channel.plugin.android.presenter.chat;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface ChatAdapterContract {

  interface View {

    void setOnMessageClickListener(OnMessageClickListener onMessageClickListener);

    void setOnActionMessageClickListener(OnActionMessageClickListener onActionMessageClickListener);

    void setOnSendingMessageClickListener(OnSendingMessageClickListener onSendingMessageClickListener);

    void setOnUserInfoListener(OnUserInfoListener onOnUserInfoListener);
  }

  interface Model {

    MessageItem getItem(int index);

    void addMessage(Message message, String chatId);
    void addMessages(List<Message> messages, String chatId);

    void addMessageItem(MessageItem item);
    void addMessageItems(Collection<MessageItem> items);
    void removeMessageItem(MessageItem item);

    int getIndex(MessageItem item);
    void setImageFilesToStorage();
  }

}
