/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subscriptions;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.subscriptions.BooleanSubscription;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.Future;

public final class Subscriptions {
    private static final Unsubscribed UNSUBSCRIBED = new Unsubscribed();

    private Subscriptions() {
        throw new IllegalStateException("No instances!");
    }

    public static Subscription empty() {
        return BooleanSubscription.create();
    }

    public static Subscription unsubscribed() {
        return UNSUBSCRIBED;
    }

    public static Subscription create(Action0 unsubscribe) {
        return BooleanSubscription.create(unsubscribe);
    }

    public static Subscription from(Future<?> f) {
        return new FutureSubscription(f);
    }

    public static CompositeSubscription from(Subscription ... subscriptions) {
        return new CompositeSubscription(subscriptions);
    }

    static final class Unsubscribed
    implements Subscription {
        Unsubscribed() {
        }

        @Override
        public void unsubscribe() {
        }

        @Override
        public boolean isUnsubscribed() {
            return true;
        }
    }

    static final class FutureSubscription
    implements Subscription {
        final Future<?> f;

        public FutureSubscription(Future<?> f) {
            this.f = f;
        }

        @Override
        public void unsubscribe() {
            this.f.cancel(true);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.f.isCancelled();
        }
    }
}

