/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.BitmapRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;

public class PhotoAlbumActivity
extends BaseActivity
implements View.OnClickListener,
PhotoViewAttacher.OnPhotoTapListener {
    private static final int ANIMATION_DURATION = 200;
    private View layoutOverlay;
    private String url;
    private String thumbnailUrl;
    private String filename;
    private Long size;
    private boolean menuVisible = true;
    private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            PhotoAlbumActivity.this.menuVisible = !PhotoAlbumActivity.this.menuVisible;
            if (PhotoAlbumActivity.this.menuVisible) {
                PhotoAlbumActivity.this.layoutOverlay.setVisibility(0);
            }
        }

        public void onAnimationEnd(Animator animator) {
            PhotoAlbumActivity.this.layoutOverlay.setVisibility(PhotoAlbumActivity.this.menuVisible ? 0 : 8);
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    };

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_photo_album);
        this.setStatusBarColor(-16777216);
        try {
            this.url = this.getIntent().getStringExtra("url");
            this.filename = this.getIntent().getStringExtra("filename");
            this.thumbnailUrl = this.getIntent().getStringExtra("thumbnailUrl");
            this.size = this.getIntent().getLongExtra("size", 0L);
        }
        finally {
            if (this.url == null || this.thumbnailUrl == null || this.filename == null || this.size == 0L) {
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
                this.finish();
            }
        }
        PhotoView photoView = (PhotoView)this.findViewById(R.id.photo_view);
        this.layoutOverlay = this.findViewById(R.id.layout_image);
        photoView.setOnPhotoTapListener(this);
        this.findViewById(R.id.button_close_image).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.button_link).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.button_download).setOnClickListener((View.OnClickListener)this);
        ((BitmapRequestBuilder)((BitmapRequestBuilder)Glide.with((FragmentActivity)this).load(this.url).asBitmap().dontAnimate()).fitCenter()).into(photoView);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_close_image) {
            this.finish();
        }
        if (id2 == R.id.button_link) {
            this.copyLink();
        }
        if (id2 == R.id.button_download) {
            this.download();
        }
    }

    private void copyLink() {
        try {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"text", (CharSequence)this.url);
            clipboard.setPrimaryClip(clip);
            UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.url_copied_to_clipboard"));
        }
        catch (Exception ex) {
            UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
        }
    }

    private void download() {
        IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", this.url).putExtra("filename", this.filename).putExtra("image", true).startActivity();
    }

    @Override
    public void onPhotoTap(View view, float x, float y) {
        this.animateOverlay();
    }

    @Override
    public void onOutsidePhotoTap() {
        this.animateOverlay();
    }

    private void animateOverlay() {
        this.layoutOverlay.animate().alpha(this.menuVisible ? 0.0f : 1.0f).setDuration(200L).setListener(this.animatorListener).start();
    }
}

