/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ManagerMessageHolder;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class ActionMessageHolder
extends ManagerMessageHolder {
    private FrameLayout simpleAction;
    private TextView simpleText;
    private ActionMessageItem item;

    public ActionMessageHolder(View itemView, final OnActionMessageClickListener listener) {
        super(itemView, null);
        this.simpleAction = (FrameLayout)itemView.findViewById(R.id.chat_action_simple);
        this.simpleText = (TextView)itemView.findViewById(R.id.chat_action_simple_text);
        this.simpleAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.actionMessageClicked(ActionMessageHolder.this.item);
                }
            }
        });
    }

    public void set(ActionMessageItem item) {
        super.set(item.getMessage(), false);
        this.setProfile(ChannelStore.getChannel());
        this.item = item;
        if (item.getActionType() == null) {
            this.contentList.setVisibility(8);
        } else {
            this.contentList.setVisibility(0);
            for (int i = 0; i < this.contentList.getChildCount(); ++i) {
                this.contentList.getChildAt(i).setVisibility(8);
            }
            switch (item.getActionType()) {
                case REQUEST_WORKING_TIME: {
                    this.simpleAction.setVisibility(0);
                    this.simpleText.setText((CharSequence)ResUtils.getString(this.itemView.getContext(), "ch.out_of_work.confirm"));
                }
            }
        }
    }
}

