package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

/**
 * Created by mika on 2017. 1. 16..
 */
public class PrefSupervisor {
  private static final String VEIL_ID = "X-Veil-Id";
  private static final String DEVICE_TOKEN = "Device-Token";
  private static final String PUSH_CHAT_ID = "Push-Chat-Id";

  private static SharedPreferences getPreferences(Context context) {
    return context.getSharedPreferences("CHANNEL_PLUGIN_PRIVATE_DATA", 0);
  }

  public static String getVeilId(Context context) {
    if (context != null) {
      return getPreferences(context).getString(VEIL_ID, null);
    }
    return null;
  }

  public static void setVeilId(Context context, String veilId) {
    if (context != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      editor.putString(VEIL_ID, veilId);
      editor.apply();
    }
  }

  public static void setDeviceToken(Context context, String token) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(DEVICE_TOKEN, token);
    editor.apply();
  }

  public static String getDeviceToken(Context context) {
    return getPreferences(context).getString(DEVICE_TOKEN, null);
  }

  public static void setPushChatId(Context context, String chatId) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(PUSH_CHAT_ID, chatId);
    editor.apply();
  }

  public static void clearPushChatId(Context context) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(PUSH_CHAT_ID, null);
    editor.apply();
  }

  public static String getPushChatId(Context context) {
    return getPreferences(context).getString(PUSH_CHAT_ID, null);
  }

  public static boolean hasPushChatId(Context context) {
    return !TextUtils.isEmpty(getPushChatId(context));
  }
}
