/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.Glide;
import com.bumptech.glide.integration.webp.decoder.WebpDrawable;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.util.Preconditions;
import java.security.MessageDigest;

public class WebpDrawableTransformation
implements Transformation<WebpDrawable> {
    private final Transformation<Bitmap> wrapped;

    public WebpDrawableTransformation(Transformation<Bitmap> wrapped) {
        this.wrapped = (Transformation)Preconditions.checkNotNull(wrapped);
    }

    public Resource<WebpDrawable> transform(Context context, Resource<WebpDrawable> resource, int outWidth, int outHeight) {
        Resource transformed;
        WebpDrawable drawable = (WebpDrawable)resource.get();
        BitmapPool bitmapPool = Glide.get((Context)context).getBitmapPool();
        Bitmap firstFrame = drawable.getFirstFrame();
        BitmapResource bitmapResource = new BitmapResource(firstFrame, bitmapPool);
        if (!bitmapResource.equals(transformed = this.wrapped.transform(context, (Resource)bitmapResource, outWidth, outHeight))) {
            bitmapResource.recycle();
        }
        Bitmap transformedFrame = (Bitmap)transformed.get();
        drawable.setFrameTransformation(this.wrapped, transformedFrame);
        return resource;
    }

    public boolean equals(Object o) {
        if (o instanceof WebpDrawableTransformation) {
            WebpDrawableTransformation other = (WebpDrawableTransformation)o;
            return this.wrapped.equals(other.wrapped);
        }
        return false;
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        this.wrapped.updateDiskCacheKey(messageDigest);
    }
}

