/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp;

import android.support.annotation.Keep;
import com.bumptech.glide.integration.webp.WebpFrame;
import com.bumptech.glide.integration.webp.WebpFrameInfo;
import com.bumptech.glide.util.Preconditions;
import java.nio.ByteBuffer;

@Keep
public class WebpImage {
    @Keep
    private long mNativePtr;
    private int mWidth;
    private int mHeigth;
    private int mFrameCount;
    private int mDurationMs;
    private int[] mFrameDurations;
    private int mLoopCount;
    private int mBackgroundColor;

    public static WebpImage create(byte[] source) {
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        return WebpImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    @Keep
    WebpImage(long nativePtr, int width, int height, int frameCount, int durationMs, int[] frameDurations, int loopCount, int backgroundColor) {
        if (nativePtr == 0L) {
            throw new RuntimeException("internal error: native WebpImage is 0");
        }
        this.mWidth = width;
        this.mHeigth = height;
        this.mFrameCount = frameCount;
        this.mDurationMs = durationMs;
        this.mFrameDurations = frameDurations;
        this.mLoopCount = loopCount;
        this.mBackgroundColor = backgroundColor;
        this.mNativePtr = nativePtr;
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize();
    }

    public void dispose() {
        this.nativeDispose();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeigth;
    }

    public int getFrameCount() {
        return this.mFrameCount;
    }

    public int getDuration() {
        return this.mDurationMs;
    }

    public int[] getFrameDurations() {
        return this.mFrameDurations;
    }

    public int getLoopCount() {
        return this.mLoopCount;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public WebpFrame getFrame(int frameNubmer) {
        return this.nativeGetFrame(frameNubmer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebpFrameInfo getFrameInfo(int frameNumber) {
        WebpFrame frame = this.getFrame(frameNumber);
        try {
            WebpFrameInfo webpFrameInfo = new WebpFrameInfo(frameNumber, frame);
            return webpFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    private static native WebpImage nativeCreateFromDirectByteBuffer(ByteBuffer var0);

    private native WebpFrame nativeGetFrame(int var1);

    private native int nativeGetSizeInBytes();

    private native void nativeDispose();

    private native void nativeFinalize();

    static {
        System.loadLibrary("glide-webp");
    }
}

