/*
 * Decompiled with CFR 0.152.
 */
package com.zingat.andversion;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zingat.andversion.AndVersionContract;
import com.zingat.andversion.IServerResponseListener;
import com.zingat.andversion.JsonParseHelper;
import com.zingat.andversion.OnCompletedListener;
import com.zingat.andversion.ParsedContentModel;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

class AndVersionPresenter
implements AndVersionContract.Presenter {
    private AndVersionContract.View mView;
    private OkHttpClient mClient = new OkHttpClient();
    private String packageName;
    private Activity activity;
    private OnCompletedListener mCompletedListener;
    private ParsedContentModel parsedContentModel = new ParsedContentModel();
    private int currentVersionCode;
    private int lastSessionVersion;

    AndVersionPresenter() {
    }

    @Override
    public void setView(AndVersionContract.View view) {
        this.mView = view;
    }

    @Override
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void setPackageInfoForPresenter() {
        try {
            PackageInfo packageInfo = this.activity.getPackageManager().getPackageInfo(this.activity.getPackageName(), 0);
            this.currentVersionCode = packageInfo.versionCode;
            this.packageName = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendUserToGooglePlay(String packageName) {
        try {
            this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName))));
        }
        catch (ActivityNotFoundException anfe) {
            this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName))));
        }
    }

    @Override
    public void checkUpdateRules(final ParsedContentModel parsedContentModel) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (parsedContentModel.getCurrentUpdateVersion() != -1 && parsedContentModel.getMinSupportVersion() != -1 && AndVersionPresenter.this.currentVersionCode < parsedContentModel.getMinSupportVersion()) {
                    AndVersionPresenter.this.mView.showForceUpdateDialog(parsedContentModel.getFeatures(), AndVersionPresenter.this.packageName);
                    return;
                }
                if (AndVersionPresenter.this.mCompletedListener != null) {
                    AndVersionPresenter.this.mCompletedListener.onCompleted();
                }
            }
        });
    }

    @Override
    public void checkNewVersionFeatures(ParsedContentModel parsedContentModel) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.lastSessionVersion = preferences.getInt("lastSessionVersion", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (this.lastSessionVersion != this.currentVersionCode) {
            if (this.lastSessionVersion != 0 && this.currentVersionCode == parsedContentModel.getCurrentUpdateVersion()) {
                this.mView.showNews(parsedContentModel.getFeatures(), this.mCompletedListener);
            } else if (this.mCompletedListener != null) {
                this.mCompletedListener.onCompleted();
            }
            this.lastSessionVersion = this.currentVersionCode;
            editor.putInt("lastSessionVersion", this.lastSessionVersion);
            editor.apply();
        } else if (this.mCompletedListener != null) {
            this.mCompletedListener.onCompleted();
        }
    }

    @Override
    public void checkForceUpdate(final ParsedContentModel parsedContentModel) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (parsedContentModel.getMinSupportVersion() != -1 && AndVersionPresenter.this.currentVersionCode < parsedContentModel.getMinSupportVersion()) {
                    AndVersionPresenter.this.mView.showForceUpdateDialog(parsedContentModel.getFeatures(), AndVersionPresenter.this.packageName);
                    return;
                }
                if (AndVersionPresenter.this.mCompletedListener != null) {
                    AndVersionPresenter.this.mCompletedListener.onCompleted();
                }
            }
        });
    }

    @Override
    public void getJsonFromUrl(@NonNull String url, final @Nullable OnCompletedListener completedListener, final @NonNull IServerResponseListener serverResponseListener) throws IOException {
        try {
            this.mCompletedListener = completedListener;
            Request request = new Request.Builder().url(url).build();
            this.mClient.newCall(request).enqueue(new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (completedListener != null) {
                                completedListener.onCompleted();
                            }
                        }
                    });
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                    ResponseBody responseBody = response.body();
                    if (responseBody != null && response.body() != null) {
                        try {
                            serverResponseListener.onParsedData(AndVersionPresenter.this.parseFeaturesContent(responseBody));
                            return;
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (completedListener != null) {
                                completedListener.onCompleted();
                            }
                        }
                    });
                }
            });
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (completedListener != null) {
                        completedListener.onCompleted();
                    }
                }
            });
        }
    }

    private ParsedContentModel parseFeaturesContent(ResponseBody responseBody) throws IOException, JSONException {
        JsonParseHelper jsonParseHelper = new JsonParseHelper();
        jsonParseHelper.setAndVersionObject(new JSONObject(responseBody.string()));
        ParsedContentModel parsedContentModel = new ParsedContentModel();
        parsedContentModel.setMinSupportVersion(jsonParseHelper.getMinSupportVersion());
        parsedContentModel.setCurrentUpdateVersion(jsonParseHelper.getCurrentVersion());
        ArrayList<String> whatsNew = jsonParseHelper.getWhatsNew();
        StringBuilder features = new StringBuilder();
        if (whatsNew != null) {
            for (int i = 0; i < whatsNew.size(); ++i) {
                features.append("- ").append(whatsNew.get(i)).append("\n");
            }
        }
        parsedContentModel.setFeatures(features.toString());
        return parsedContentModel;
    }
}

