package com.zing.zalo.zalosdk.payment.direct;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.os.Build.VERSION;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View.MeasureSpec;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;

public class DynamicLayout extends RelativeLayout {
    int mBoundedWidth = 900;
    int w;

    public DynamicLayout(Context context) {
        super(context);
    }

    public DynamicLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @TargetApi(13)
    protected void onMeasure(int i, int i2) {
        if (DeviceHelper.isTablet(getContext())) {
            int i3;
            int i4;
            Display defaultDisplay = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
            if (VERSION.SDK_INT >= 13) {
                Point point = new Point();
                defaultDisplay.getSize(point);
                i3 = point.x;
                i4 = point.y;
            } else {
                i3 = defaultDisplay.getWidth();
                i4 = defaultDisplay.getHeight();
            }
            if (MeasureSpec.getSize(i) < MeasureSpec.getSize(i2)) {
                this.mBoundedWidth = (int) (((double) i3) * 0.8d);
            } else {
                this.mBoundedWidth = (int) (((double) i4) * 0.8d);
            }
            if (this.mBoundedWidth < MeasureSpec.getSize(i)) {
                this.w = MeasureSpec.makeMeasureSpec(this.mBoundedWidth, MeasureSpec.getMode(i));
            }
        } else if (MeasureSpec.getSize(i) < MeasureSpec.getSize(i2)) {
            this.w = i;
        } else {
            this.w = i2 + 50;
        }
        super.onMeasure(this.w, i2);
    }
}
