/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.m.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.support.v4.app.Fragment;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    public static List<String> findDeniedPermissions(Activity activity, String ... permission) {
        ArrayList<String> denyPermissions = new ArrayList<String>();
        for (String value : permission) {
            if (activity.checkSelfPermission(value) == 0) continue;
            denyPermissions.add(value);
        }
        return denyPermissions;
    }

    public static List<Method> findAnnotationMethods(Class clazz, Class<? extends Annotation> clazz1) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(clazz1)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static Activity getActivity(Object object) {
        if (object instanceof Fragment) {
            return ((Fragment)object).getActivity();
        }
        if (object instanceof Activity) {
            return (Activity)object;
        }
        return null;
    }
}

