/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.m.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import com.zhy.m.permission.PermissionProxy;
import com.zhy.m.permission.Utils;
import java.util.ArrayList;
import java.util.List;

public class MPermissions {
    private static final String SUFFIX = "$$PermissionProxy";

    public static void requestPermissions(Activity object, int requestCode, String ... permissions) {
        MPermissions._requestPermissions(object, requestCode, permissions);
    }

    public static void requestPermissions(Fragment object, int requestCode, String ... permissions) {
        MPermissions._requestPermissions(object, requestCode, permissions);
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission, int requestCode) {
        PermissionProxy proxy = MPermissions.findPermissionProxy(activity);
        if (!proxy.needShowRationale(requestCode)) {
            return false;
        }
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) {
            proxy.rationale(activity, requestCode);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=23)
    private static void _requestPermissions(Object object, int requestCode, String ... permissions) {
        if (!Utils.isOverMarshmallow()) {
            MPermissions.doExecuteSuccess(object, requestCode);
            return;
        }
        List<String> deniedPermissions = Utils.findDeniedPermissions(Utils.getActivity(object), permissions);
        if (deniedPermissions.size() > 0) {
            if (object instanceof Activity) {
                ((Activity)object).requestPermissions(deniedPermissions.toArray(new String[deniedPermissions.size()]), requestCode);
                return;
            } else {
                if (!(object instanceof Fragment)) throw new IllegalArgumentException(object.getClass().getName() + " is not supported!");
                ((Fragment)object).requestPermissions(deniedPermissions.toArray(new String[deniedPermissions.size()]), requestCode);
            }
            return;
        } else {
            MPermissions.doExecuteSuccess(object, requestCode);
        }
    }

    private static PermissionProxy findPermissionProxy(Object activity) {
        try {
            Class<?> clazz = activity.getClass();
            Class<?> injectorClazz = Class.forName(clazz.getName() + SUFFIX);
            return (PermissionProxy)injectorClazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        throw new RuntimeException(String.format("can not find %s , something when compiler.", activity.getClass().getSimpleName() + SUFFIX));
    }

    private static void doExecuteSuccess(Object activity, int requestCode) {
        MPermissions.findPermissionProxy(activity).grant(activity, requestCode);
    }

    private static void doExecuteFail(Object activity, int requestCode) {
        MPermissions.findPermissionProxy(activity).denied(activity, requestCode);
    }

    public static void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        MPermissions.requestResult(activity, requestCode, permissions, grantResults);
    }

    public static void onRequestPermissionsResult(Fragment fragment, int requestCode, String[] permissions, int[] grantResults) {
        MPermissions.requestResult(fragment, requestCode, permissions, grantResults);
    }

    private static void requestResult(Object obj, int requestCode, String[] permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] == 0) continue;
            deniedPermissions.add(permissions[i]);
        }
        if (deniedPermissions.size() > 0) {
            MPermissions.doExecuteFail(obj, requestCode);
        } else {
            MPermissions.doExecuteSuccess(obj, requestCode);
        }
    }
}

