/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.push.services;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import com.zhuge.push.msg.ConnectionManager;
import com.zhuge.push.msg.ZhugePushConfig;
import com.zhuge.push.msg.ZhugeUtils;
import com.zhuge.sys.services.SysUtils;
import com.zhuge.sys.services.TelephonyUtils;
import com.zhuge.sys.services.WifiInfoUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushService
extends Service {
    private String did;
    private ConnectionManager connectionManager = null;
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static boolean isStarted = false;
    private static boolean onLogin = false;

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            ZhugePushConfig.echo("\u542f\u52a8:" + isStarted + "|did:" + this.did);
            isStarted = true;
            if (SysUtils.isNetworkAvailable(this.getApplicationContext())) {
                if (this.connectionManager == null || !this.connectionManager.getLoginStatus()) {
                    if (!onLogin) {
                        onLogin = true;
                        this.doLogin();
                    }
                } else {
                    int command = intent.getIntExtra("cmd", 2);
                    Bundle data = intent.getBundleExtra("data");
                    this.handCommand(command, data);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getDid() {
        String imei = null;
        String mac = null;
        try {
            imei = new TelephonyUtils(this.getApplicationContext()).getTM().getDeviceId();
        }
        catch (Exception e) {
            e.printStackTrace();
            ZhugePushConfig.echo("\u83b7\u53d6imei\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650READ_PHONE_STATE");
        }
        try {
            mac = new WifiInfoUtils(this.getApplicationContext()).getMacAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            ZhugePushConfig.echo("\u83b7\u53d6MAC\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650ACCESS_WIFI_STATE");
        }
        if (mac == null && imei == null) {
            this.stopSelf();
        }
        return ZhugeUtils.md5(imei + mac);
    }

    public void startLongPolling() {
        try {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (SysUtils.isNetworkAvailable(PushService.this.getApplicationContext()) && isStarted) {
                            try {
                                if (PushService.this.connectionManager != null) {
                                    PushService.this.connectionManager.halt();
                                }
                                PushService.this.ensureExecutorService();
                                PushService.this.connectionManager = new ConnectionManager(PushService.this.getApplicationContext(), PushService.this.did);
                                boolean build = PushService.this.connectionManager.buildConnection();
                                if (!build) {
                                    ZhugePushConfig.echo("service \u8fde\u63a5\u5931\u8d25");
                                } else {
                                    boolean loginResult;
                                    ZhugePushConfig.echo("service \u8fde\u63a5\u6210\u529f");
                                    Thread dealThread = PushService.this.connectionManager.dealingMsg();
                                    Thread executeThread = PushService.this.connectionManager.executeQueue();
                                    if (dealThread != null) {
                                        PushService.this.executorService.execute(dealThread);
                                    }
                                    if (executeThread != null) {
                                        PushService.this.executorService.execute(executeThread);
                                    }
                                    if (!(loginResult = PushService.this.connectionManager.login())) {
                                        ZhugePushConfig.echo("service \u767b\u5f55\u5931\u8d25");
                                    } else {
                                        ZhugePushConfig.echo("service \u767b\u5f55\u6210\u529f");
                                    }
                                }
                                if (PushService.this.connectionManager.getLoginStatus()) {
                                    break;
                                }
                                Thread.sleep(5000L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        onLogin = false;
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doLogin() {
        this.did = this.getDid();
        ZhugePushConfig.echo("\u8bbe\u5907id:" + this.did);
        this.startLongPolling();
    }

    public void handCommand(int cmd, Bundle data) {
        try {
            switch (cmd) {
                case 2: {
                    boolean status = this.connectionManager.isOnline();
                    ZhugePushConfig.echo(status + ":online");
                    if (status) break;
                    ZhugePushConfig.echo("\u91cd\u65b0\u767b\u5f55");
                    onLogin = true;
                    this.doLogin();
                    break;
                }
                case 1: {
                    if (data == null) {
                        return;
                    }
                    String appId = data.getString("appKey");
                    String pkg = data.getString("pkg");
                    String clientId = this.connectionManager.getClientId(appId);
                    Intent intent = new Intent(pkg + ".recieve");
                    intent.putExtra("cid", clientId);
                    this.sendBroadcast(intent);
                    break;
                }
                case 3: {
                    if (data == null) {
                        return;
                    }
                    String aid = data.getString("appid");
                    String mid = data.getString("mid");
                    this.connectionManager.markMsg(aid, mid);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDestroy() {
        try {
            ZhugePushConfig.echo("\u5173\u5566");
            if (this.connectionManager != null) {
                this.connectionManager.halt();
            }
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
            ZhugePushConfig.echo("shutdown:" + this.executorService.isShutdown());
            isStarted = false;
            super.onDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void ensureExecutorService() {
        if (this.executorService.isShutdown()) {
            this.executorService = Executors.newFixedThreadPool(2);
        } else {
            this.executorService.shutdownNow();
            this.executorService = Executors.newFixedThreadPool(2);
        }
    }
}

