/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.push.msg;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.zhuge.push.broadcastrecievers.UserReciever;
import com.zhuge.sys.services.ManifestUtils;
import com.zhuge.sys.services.SysUtils;
import org.json.JSONArray;

public class ZGPush {
    public static ZGPush getInstance() {
        return SingletonHolder.instance;
    }

    public void initialize(Context context) {
        try {
            Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), "com.zhuge.push.services.PushService");
            serviceIntent.putExtra("cmd", 2);
            context.startService(serviceIntent);
            SharedPreferences sharedPreferences = context.getSharedPreferences("ZHUGE_PUSH", 0);
            String cid = sharedPreferences.getString("ZHUGE_CID", null);
            if (cid == null) {
                this.queryCid(context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy(Context context) {
        try {
            Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), "com.zhuge.push.services.PushService");
            context.stopService(serviceIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ping(Context context) {
        try {
            Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), "com.zhuge.push.services.PushService");
            serviceIntent.putExtra("cmd", 2);
            context.startService(serviceIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void queryCid(Context context) {
        try {
            Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), "com.zhuge.push.services.PushService");
            serviceIntent.putExtra("cmd", 1);
            Bundle bundle = new Bundle();
            bundle.putString("appKey", ManifestUtils.getPushKey(context));
            bundle.putString("pkg", context.getPackageName());
            serviceIntent.putExtra("data", bundle);
            context.startService(serviceIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONArray dealCustom(Activity activity) {
        Intent intent = activity.getIntent();
        if (intent != null) {
            try {
                String params = intent.getStringExtra("custom");
                if (params == null) {
                    return null;
                }
                JSONArray jsonArray = new JSONArray(params);
                return jsonArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void msgStatistics(Activity activity) {
        Intent intent = activity.getIntent();
        if (intent != null) {
            try {
                String appid = intent.getStringExtra("appid");
                String mid = intent.getStringExtra("mid");
                if (appid != null && mid != null) {
                    UserReciever.markMsg(activity.getApplicationContext(), appid, mid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class SingletonHolder {
        static final ZGPush instance = new ZGPush();

        private SingletonHolder() {
        }
    }
}

