/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.push.msg;

import com.zhuge.push.msg.EncryptUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.json.JSONObject;

public class MessageHandler {
    public static final short HEAD_LEN = 8;
    public static final short LOGIN = 4096;
    public static final short HEARTBEAT = 4098;
    public static final short GET_CID = 4102;
    public static final short CLEAR_UNREAD = 4104;
    public static final short MARK_READ = 4112;
    public static final short SET_BLOCK = 4114;
    public static final short GET_BLOCK = 4116;
    public static final short SET_AVAILABLE = 4118;
    public static final short GET_AVAILABLE = 4120;
    public static final short GET_MSG = 8192;
    public static final short COMPRESS = 0;
    public static final short ENCRYPT = 1;
    public static final float VERION = 1.0f;
    public static long sequence = 0L;
    public static final String PUBLICPEM = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCpcqqjjJTnld70B1AJvMc/HOn4LwxNbgbv1c2rWQ6W0AdXy201tLelmhblZ3ex205ILvye6YDOQK07hhdyKAeCzHtlzf46IuhMlkZjIZlSR62a1WMH7WAldzDFmHglifBg2OX/60UwPQVQb7yBCo+CJKltwXEui+aIO0Q7n05ABQIDAQAB";
    public static String privateKey = MessageHandler.generateString("abcdefghijklmnopqrstuvwxyz1234567890", 16);

    public static byte[] constructPackage(short type, byte[] body) {
        int totalLength = body.length + 8;
        byte[] header = MessageHandler.getBytesFromShort(2, (short)8);
        byte[] cmd = MessageHandler.getBytesFromShort(2, type);
        byte[] total = MessageHandler.getBytesFromInt(4, totalLength);
        ByteBuffer byteBuffer = ByteBuffer.allocate(totalLength);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(header);
        byteBuffer.put(cmd);
        byteBuffer.put(total);
        byteBuffer.put(body);
        return byteBuffer.array();
    }

    public static byte[] getBytesFromShort(int len, short value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(len);
        byteBuffer.putShort(value);
        return byteBuffer.array();
    }

    public static byte[] getBytesFromInt(int len, int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(len);
        byteBuffer.putInt(value);
        return byteBuffer.array();
    }

    public static byte[] getLoginRequest(String did, long seq) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("did", (Object)did);
            jsonObject.put("dtype", 1);
            jsonObject.put("compress", 0);
            jsonObject.put("encrypt", 1);
            EncryptUtils encryptUtils = new EncryptUtils("RSA/ECB/PKCS1Padding");
            jsonObject.put("pwd", (Object)encryptUtils.rsaEncrypt(encryptUtils.getRsaPublicKey(PUBLICPEM), privateKey));
            jsonObject.put("ver", 1.0);
            jsonObject.put("seq", seq);
            byte[] logBytes = jsonObject.toString().getBytes();
            return MessageHandler.constructPackage((short)4096, logBytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getClientIdRequest(String appKey, long seq) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("appid", (Object)appKey);
            jsonObject.put("dtype", 1);
            jsonObject.put("ver", 1.0);
            jsonObject.put("seq", seq);
            byte[] logBytes = jsonObject.toString().getBytes();
            return MessageHandler.constructPackage((short)4102, logBytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getMarkReadRequest(String appKey, String mid, long seq) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("appid", (Object)appKey);
            jsonObject.put("id", (Object)mid);
            jsonObject.put("ver", 1.0);
            jsonObject.put("seq", seq);
            byte[] logBytes = jsonObject.toString().getBytes();
            return MessageHandler.constructPackage((short)4112, logBytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] confirmMsg(String msgid, int ack_type, String router, String appid) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)msgid);
            jsonObject.put("appid", (Object)appid);
            jsonObject.put("ack_type", ack_type);
            jsonObject.put("router", (Object)router);
            byte[] confirmBytes = jsonObject.toString().getBytes();
            return MessageHandler.constructPackage((short)8193, confirmBytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] sendHeartbeat(long seq) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("ver", 1.0);
            jsonObject.put("seq", seq);
            byte[] logBytes = jsonObject.toString().getBytes();
            return MessageHandler.constructPackage((short)4098, logBytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String generateString(String characters, int length) {
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = characters.charAt(new Random().nextInt(characters.length()));
        }
        return new String(text);
    }
}

