/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.push.msg;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.zhuge.push.msg.EncryptUtils;
import com.zhuge.push.msg.MessageHandler;
import com.zhuge.push.msg.ZGPush;
import com.zhuge.push.msg.ZhugePushConfig;
import com.zhuge.sys.services.SysUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConnectionManager {
    private String did;
    public Socket socket;
    private DataInputStream inputWriter;
    private DataOutputStream outWriter;
    private long seq = 0L;
    public boolean isLogin = false;
    private static final int CONN_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 60000;
    private static final int RESULT_TIMEOUT = 20000;
    private BlockingQueue<byte[]> requestQueue = new LinkedBlockingQueue<byte[]>();
    public boolean readStop = false;
    public boolean executeStop = false;
    public Thread readThread;
    public Thread executeThread;
    private HashMap<Long, JSONObject> resultMap = new HashMap();
    private Context context;

    public ConnectionManager(Context context, String did) {
        this.did = did;
        this.context = context;
    }

    private String getConnectString() {
        if (this.did != null) {
            try {
                String url = "http://apipool.37degree.com/open/?method=setting_srv.srv_list_get&did=" + this.did;
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpResponse response = httpclient.execute((HttpUriRequest)new HttpGet(url));
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() == 200) {
                    JSONObject dataObject;
                    JSONArray serverArray;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    response.getEntity().writeTo((OutputStream)out);
                    out.close();
                    String responseString = out.toString();
                    JSONObject jsonObject = new JSONObject(responseString);
                    if (jsonObject.getInt("return_code") == 0 && (serverArray = (dataObject = jsonObject.getJSONObject("data")).getJSONArray("servers")).length() > 0) {
                        return (String)serverArray.get(new Random().nextInt(serverArray.length()));
                    }
                    return responseString;
                }
                response.getEntity().getContent().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean buildConnection() {
        try {
            String serverString = this.getConnectString();
            if (serverString != null) {
                String[] serverInfo = serverString.split(":");
                try {
                    this.socket = new Socket();
                    this.socket.connect(new InetSocketAddress(serverInfo[0], Integer.parseInt(serverInfo[1])), 30000);
                    this.socket.setKeepAlive(true);
                    this.socket.setSoTimeout(60000);
                    this.inputWriter = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    this.outWriter = new DataOutputStream(this.socket.getOutputStream());
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean sendRequest(byte[] info) {
        try {
            this.outWriter.write(info);
            return true;
        }
        catch (SocketException e) {
            try {
                this.readStop = true;
                this.executeStop = true;
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean login() {
        try {
            long presentSeq = this.getSeq();
            byte[] byteInfo = MessageHandler.getLoginRequest(this.did, presentSeq);
            this.requestQueue.put(byteInfo);
            long beginTime = System.currentTimeMillis();
            ZhugePushConfig.echo("service \u767b\u5f55" + presentSeq);
            while (this.socket != null && !this.socket.isClosed()) {
                JSONObject result = this.resultMap.get(presentSeq);
                if (result != null) {
                    this.resultMap.remove(presentSeq);
                    if (result.getInt("ret") == 0) {
                        this.isLogin = true;
                        return true;
                    }
                    ZhugePushConfig.echo("service \u767b\u5f55\u7ed3\u679c\u9519\u8bef");
                    return false;
                }
                if (System.currentTimeMillis() - beginTime > 20000L) {
                    ZhugePushConfig.echo("service \u767b\u5f55\u8d85\u65f6");
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean markMsg(String appId, String mid) {
        try {
            long presentSeq = this.getSeq();
            byte[] byteInfo = MessageHandler.getMarkReadRequest(appId, mid, presentSeq);
            this.requestQueue.put(byteInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getClientId(String appKey) {
        try {
            long presentSeq = this.getSeq();
            byte[] byteInfo = MessageHandler.getClientIdRequest(appKey, presentSeq);
            this.requestQueue.put(byteInfo);
            long beginTime = System.currentTimeMillis();
            while (this.socket != null && !this.socket.isClosed()) {
                JSONObject result = this.resultMap.get(presentSeq);
                if (result != null) {
                    this.resultMap.remove(presentSeq);
                    return result.getString("cid");
                }
                if (System.currentTimeMillis() - beginTime <= 20000L) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isOnline() {
        try {
            long presentSeq = this.getSeq();
            this.requestQueue.put(MessageHandler.sendHeartbeat(presentSeq));
            long beginTime = System.currentTimeMillis();
            while (this.socket != null && !this.socket.isClosed()) {
                JSONObject result = this.resultMap.get(presentSeq);
                if (result != null) {
                    this.resultMap.remove(presentSeq);
                    return true;
                }
                if (System.currentTimeMillis() - beginTime <= 20000L) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isLogin = false;
        return false;
    }

    private synchronized long getSeq() {
        ++this.seq;
        return this.seq;
    }

    public boolean getLoginStatus() {
        return this.isLogin;
    }

    private JSONObject getResponse() {
        try {
            byte[] headers = new byte[8];
            this.inputWriter.read(headers);
            byte[] typelen = new byte[2];
            byte[] totallen = new byte[4];
            for (int i = 2; i < 4; ++i) {
                typelen[i - 2] = headers[i];
            }
            ByteBuffer typeBuffer = ByteBuffer.wrap(typelen);
            typeBuffer.order(ByteOrder.BIG_ENDIAN);
            short type_len = typeBuffer.getShort();
            for (int i = 4; i < 8; ++i) {
                totallen[i - 4] = headers[i];
            }
            ByteBuffer totalBuffer = ByteBuffer.wrap(totallen);
            totalBuffer.order(ByteOrder.BIG_ENDIAN);
            int response_len = totalBuffer.getInt();
            if (response_len == 0) {
                return null;
            }
            byte[] body = new byte[response_len - 8];
            this.inputWriter.read(body);
            ByteBuffer bodyBuffer = ByteBuffer.wrap(body);
            bodyBuffer.order(ByteOrder.BIG_ENDIAN);
            bodyBuffer.put(body);
            String response = "";
            response = type_len == 8192 ? new EncryptUtils("AES/CBC/NoPadding").aesDecrypt(bodyBuffer.array(), MessageHandler.privateKey) : new String(bodyBuffer.array());
            if (response.startsWith("{")) {
                JSONObject returnObject = new JSONObject(response);
                returnObject.put("msgtype", (int)type_len);
                return returnObject;
            }
        }
        catch (Exception e) {
            try {
                ZGPush.getInstance().ping(this.context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void msgDealer(JSONObject msgObject) {
        if (msgObject == null) {
            return;
        }
        try {
            int typeLen = msgObject.getInt("msgtype");
            switch (typeLen) {
                case 4097: {
                    ZhugePushConfig.echo("service \u767b\u5f55\u7ed3\u679c" + msgObject.getLong("seq"));
                    this.resultMap.put(msgObject.getLong("seq"), msgObject);
                    break;
                }
                case 4099: {
                    this.resultMap.put(msgObject.getLong("seq"), msgObject);
                    break;
                }
                case 4103: {
                    this.resultMap.put(msgObject.getLong("seq"), msgObject);
                    break;
                }
                case 8192: {
                    this.distributeMsg(msgObject);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void distributeMsg(JSONObject msgObject) {
        try {
            byte[] confirmRequest = MessageHandler.confirmMsg(msgObject.getString("id"), msgObject.getInt("ack_type"), msgObject.getString("router"), msgObject.getString("appid"));
            this.requestQueue.put(confirmRequest);
            Bundle bundle = this.getBundle(msgObject);
            String pkg = bundle.getString("pkg");
            if (bundle != null) {
                Intent intent = new Intent(pkg + ".msg");
                intent.putExtra("msg", bundle);
                this.context.sendBroadcast(intent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Thread executeQueue() {
        this.executeStop = false;
        if (this.executeThread == null) {
            this.executeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!ConnectionManager.this.executeStop) {
                        try {
                            byte[] request = (byte[])ConnectionManager.this.requestQueue.take();
                            boolean result = false;
                            while (ConnectionManager.this.socket != null && !ConnectionManager.this.socket.isClosed() && !result) {
                                result = ConnectionManager.this.sendRequest(request);
                                if (SysUtils.isNetworkAvailable(ConnectionManager.this.context)) continue;
                                ZGPush.getInstance().destroy(ConnectionManager.this.context);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            return this.executeThread;
        }
        return this.executeThread;
    }

    public Thread dealingMsg() {
        this.readStop = false;
        if (this.readThread == null) {
            this.readThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!ConnectionManager.this.readStop && !ConnectionManager.this.socket.isClosed()) {
                        try {
                            if (!SysUtils.isNetworkAvailable(ConnectionManager.this.context)) {
                                ZGPush.getInstance().destroy(ConnectionManager.this.context);
                                break;
                            }
                            JSONObject jsonObject = ConnectionManager.this.getResponse();
                            ConnectionManager.this.msgDealer(jsonObject);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            return this.readThread;
        }
        return this.readThread;
    }

    public Bundle getBundle(JSONObject jsonObject) {
        try {
            if (jsonObject != null && jsonObject.getString("alert") != null) {
                JSONObject androidObject = new JSONObject(jsonObject.getString("alert"));
                Bundle bundle = new Bundle();
                bundle.putString("mid", jsonObject.getString("id"));
                bundle.putString("appid", jsonObject.getString("appid"));
                bundle.putString("title", androidObject.getString("title"));
                bundle.putString("pkg", androidObject.getString("pkg"));
                bundle.putString("content", androidObject.getString("alert"));
                bundle.putBoolean("screen", androidObject.getJSONObject("attr").getBoolean("screen"));
                bundle.putBoolean("ring", androidObject.getJSONObject("attr").getBoolean("ring"));
                bundle.putBoolean("vibrate", androidObject.getJSONObject("attr").getBoolean("vibrate"));
                bundle.putInt("noticetype", androidObject.getJSONObject("attr").getInt("noticetype"));
                bundle.putInt("flag", androidObject.getJSONObject("attr").getJSONObject("clickevent").getInt("flag"));
                bundle.putString("page", androidObject.getJSONObject("attr").getJSONObject("clickevent").getString("value"));
                bundle.putString("custom", androidObject.getJSONObject("attr").getJSONArray("parameters").toString());
                return bundle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void halt() {
        try {
            this.executeStop = true;
            this.readStop = true;
            this.inputWriter.close();
            this.outWriter.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

