/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.push.broadcastrecievers;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import com.zhuge.push.msg.ZGPush;
import com.zhuge.push.msg.ZhugePushConfig;
import com.zhuge.sys.services.SysUtils;

public class UserReciever
extends BroadcastReceiver {
    public static final String RECIEVE = ".recieve";
    public static final String PRESENT = "android.intent.action.USER_PRESENT";
    public static final String MSG = ".msg";

    public void onReceive(Context context, Intent intent) {
        block17: {
            String action = intent.getAction();
            if (action.equals(context.getPackageName() + RECIEVE)) {
                try {
                    String clientId = intent.getStringExtra("cid");
                    ZhugePushConfig.echo(clientId + ":cid");
                    if (clientId != null) {
                        SharedPreferences sharedPreferences = context.getSharedPreferences("ZHUGE_PUSH", 0);
                        sharedPreferences.edit().putString("ZHUGE_CID", clientId).commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (action.equals(PRESENT) || action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                try {
                    if (SysUtils.isNetworkAvailable(context)) {
                        ZGPush.getInstance().initialize(context);
                        break block17;
                    }
                    ZGPush.getInstance().destroy(context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (action.equals(context.getPackageName() + MSG)) {
                try {
                    Bundle msg = intent.getBundleExtra("msg");
                    switch (msg.getInt("noticetype")) {
                        case 1: {
                            this.showNotification(context, msg);
                            break;
                        }
                        case 2: {
                            this.showAlert(context, msg);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void showAlert(final Context context, final Bundle info) {
        AlertDialog.Builder dialog = new AlertDialog.Builder(context).setTitle((CharSequence)info.getString("title")).setMessage((CharSequence)info.getString("content")).setNegativeButton((CharSequence)"\u53d6\u6d88", null).setIcon(SysUtils.getId(context, "drawable", "push")).setPositiveButton((CharSequence)"\u67e5\u770b", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                int flag = info.getInt("flag");
                Intent resultIntent = null;
                UserReciever.markMsg(context, info.getString("appid"), info.getString("mid"));
                switch (flag) {
                    case 1: {
                        resultIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                        break;
                    }
                    case 2: {
                        ComponentName comp = new ComponentName(context.getPackageName(), info.getString("page"));
                        resultIntent = new Intent();
                        resultIntent.setComponent(comp);
                        break;
                    }
                    case 3: {
                        String url = info.getString("page");
                        resultIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    }
                }
                if (resultIntent != null) {
                    resultIntent.putExtra("custom", info.getString("custom"));
                    resultIntent.addFlags(0x10000000);
                    context.startActivity(resultIntent);
                }
            }
        });
        AlertDialog mDialog = dialog.create();
        mDialog.getWindow().setType(2003);
        mDialog.show();
        if (info.getBoolean("vibrate")) {
            SysUtils.doVibrate(context);
        }
        if (info.getBoolean("screen")) {
            SysUtils.doWakeLock(context);
        }
        if (info.getBoolean("ring")) {
            SysUtils.doRing(context);
        }
    }

    public void showNotification(Context context, Bundle info) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context).setContentTitle((CharSequence)info.getString("title")).setContentText((CharSequence)info.getString("content")).setSmallIcon(SysUtils.getId(context, "drawable", "push"));
        Intent resultIntent = null;
        int flag = info.getInt("flag");
        switch (flag) {
            case 1: {
                resultIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                break;
            }
            case 2: {
                ComponentName comp = new ComponentName(context.getPackageName(), info.getString("page"));
                resultIntent = new Intent();
                resultIntent.setComponent(comp);
                break;
            }
            case 3: {
                String url = info.getString("page");
                resultIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            }
        }
        if (resultIntent != null) {
            resultIntent.putExtra("custom", info.getString("custom"));
            resultIntent.putExtra("appid", info.getString("appid"));
            resultIntent.putExtra("mid", info.getString("mid"));
            TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)context);
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(0, 0x10000000);
            mBuilder.setContentIntent(resultPendingIntent);
            Notification notification = mBuilder.build();
            if (info.getBoolean("vibrate")) {
                SysUtils.doVibrate(context);
            }
            if (info.getBoolean("screen")) {
                SysUtils.doWakeLock(context);
            }
            if (info.getBoolean("ring")) {
                SysUtils.doRing(context);
            }
            notification.flags |= 0x10;
            NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
            mNotificationManager.notify(0, notification);
        }
    }

    public static void markMsg(Context context, String aid, String mid) {
        Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), "com.zhuge.push.services.PushService");
        serviceIntent.putExtra("cmd", 3);
        Bundle bundle = new Bundle();
        bundle.putString("appid", aid);
        bundle.putString("mid", mid);
        serviceIntent.putExtra("data", bundle);
        context.startService(serviceIntent);
    }
}

