package com.zhuge.sys.services;

import java.lang.reflect.Field;
import java.util.List;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.os.Vibrator;
import android.util.Log;

import com.zhuge.push.msg.ZhugePushConfig;

public class SysUtils {
		
	public static boolean isServiceRunning(Context context){
		ActivityManager _ActivityManager = (ActivityManager) context
                .getSystemService(Context.ACTIVITY_SERVICE);
        List<RunningAppProcessInfo> list = _ActivityManager
                .getRunningAppProcesses();
        for (RunningAppProcessInfo runningAppProcessInfo : list) {
			if (runningAppProcessInfo.processName.contains("zhuge_push_v1")) {
				ZhugePushConfig.echo("running:"+runningAppProcessInfo.processName);
				return true;
			}
		}
		return false;
	}
	
	public static String getRunningServicePkg(Context context){
		ActivityManager _ActivityManager = (ActivityManager) context
                .getSystemService(Context.ACTIVITY_SERVICE);
        List<RunningAppProcessInfo> list = _ActivityManager
                .getRunningAppProcesses();
        for (RunningAppProcessInfo runningAppProcessInfo : list) {
			if (runningAppProcessInfo.processName.contains("zhuge_push_v1")) {
				return runningAppProcessInfo.pkgList[0];
			}
		}
		return null;
	}
	
	public static Intent createExplicitFromImplicitIntent(Context context, Intent implicitIntent, String packageName, String className) {
        
        ComponentName component = null;
        if (packageName != null && className != null) {
        	component = new ComponentName(packageName, className);
        	
		}else {
	        PackageManager pm = context.getPackageManager();
	        List<ResolveInfo> resolveInfo = pm.queryIntentServices(implicitIntent, 0);
	        if (resolveInfo == null || resolveInfo.size() == 0) {
	            return null;
	        }
	        ResolveInfo serviceInfo = resolveInfo.get(0);
			packageName = serviceInfo.serviceInfo.packageName;
			
			className = serviceInfo.serviceInfo.name;
		}
        if (packageName == null) {
			return implicitIntent;
		}
        component = new ComponentName(packageName, className);    
        // Create a new intent. Use the old one for extras and such reuse
        Intent explicitIntent = new Intent(implicitIntent);
        // Set the component to be explicit
        explicitIntent.setComponent(component);
 
        return explicitIntent;
    }
	
	public static int getId(Context paramContext, String paramString1, String paramString2)
    {
        try
        {
            Class<?> localClass = Class.forName(paramContext.getPackageName() + ".R$" + paramString1);
            Field localField = localClass.getField(paramString2);
            int i = Integer.parseInt(localField.get(localField.getName()).toString());
            return i;
        } catch (Exception localException)
        {
            Log.e("getIdByReflection error", localException.getMessage());
        }
        return 0;
    }
	
	public static void doVibrate(Context context){
		Vibrator vibrator = (Vibrator)context.getSystemService(Context.VIBRATOR_SERVICE);
		vibrator.vibrate(1000);
		vibrator.cancel();
	}
	
	public static void doWakeLock(Context context){
		PowerManager pm = (PowerManager)context.getSystemService(Context.POWER_SERVICE);
		 boolean isScreenOn = pm.isScreenOn();

         if(isScreenOn==false)
         {
        	 WakeLock wl = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK |PowerManager.ACQUIRE_CAUSES_WAKEUP |PowerManager.ON_AFTER_RELEASE,"MyLock");
        	 wl.acquire(5000);
         }
	}
	
	public static void doRing(Context context){
		try {
			MediaPlayer mp = new MediaPlayer();  
			mp.setDataSource(context, RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION));  
			mp.prepare();  
			mp.start();
		} catch (Exception e) {
			e.printStackTrace();
		}		
	}
	
	public static boolean isNetworkAvailable(Context context){
		ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);  
        if (cm != null) {  
            NetworkInfo[] infos = cm.getAllNetworkInfo();  
            if (infos != null) {  
                for (NetworkInfo ni : infos) {  
                    if (ni.isConnected()) {  
                        return true;  
                    }  
                }  
            }  
        }  
        return false;
	}
}
