package com.zhuge.push.services;


import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;

import com.zhuge.push.msg.ConnectionManager;
import com.zhuge.push.msg.ZhugePushConfig;
import com.zhuge.push.msg.ZhugeUtils;
import com.zhuge.sys.services.SysUtils;
import com.zhuge.sys.services.TelephonyUtils;
import com.zhuge.sys.services.WifiInfoUtils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushService extends Service {

	private String did;
	private ConnectionManager connectionManager = null;
	private ExecutorService executorService = Executors.newFixedThreadPool(2);
	private static boolean isStarted = false;
	private static boolean onLogin = false;
	
	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		try {
			ZhugePushConfig.echo("启动:"+isStarted+"|did:"+did);
			isStarted = true;
			if (SysUtils.isNetworkAvailable(getApplicationContext())) {
				if ((connectionManager == null || !connectionManager.getLoginStatus())) {
					if (!onLogin) {
						onLogin = true;
						doLogin();
					}				
				}else {
					int command = intent.getIntExtra("cmd", ZhugePushConfig.PING);
					Bundle data = intent.getBundleExtra("data");
					handCommand(command, data);
				}
			}			
		} catch (Exception e) {
		}
		
		return super.onStartCommand(intent, flags, startId);
	}

	@Override
	public IBinder onBind(Intent intent) {
		return null;
	}
	
	public ConnectionManager getConnectionManager(){
		return this.connectionManager;
	}
	

	public String getDid(){
		String imei = null, mac = null;
		try {
	        imei = new TelephonyUtils(getApplicationContext()).getTM().getDeviceId();;
	        }catch (Exception e){
	        	e.printStackTrace();
	            ZhugePushConfig.echo("获取imei失败，检查权限READ_PHONE_STATE");
	        }
        try {
            mac = new WifiInfoUtils(getApplicationContext()).getMacAddress();
        }catch (Exception e){
        	e.printStackTrace();
            ZhugePushConfig.echo("获取MAC失败，检查权限ACCESS_WIFI_STATE");
        }
        if(mac == null && imei == null) stopSelf();;
        return ZhugeUtils.md5(imei+mac);
	}

	public  void startLongPolling(){
		try {
			new Thread(new Runnable() {
				
				@Override
				public void run() {
					try {
				        while(SysUtils.isNetworkAvailable(getApplicationContext()) && isStarted){
				        	try {
				        		if (connectionManager != null) {
				        			connectionManager.halt();
								}
				        		ensureExecutorService();
				        		connectionManager = new ConnectionManager(getApplicationContext(), did);
								boolean build = connectionManager.buildConnection();
								if (!build) {
									ZhugePushConfig.echo("service 连接"+"失败");
								}else {
									ZhugePushConfig.echo("service 连接"+"成功");									
									Thread dealThread = connectionManager.dealingMsg();
									Thread executeThread = connectionManager.executeQueue();
									if (dealThread != null) {
										executorService.execute(dealThread);
									}
									if (executeThread != null) {
										executorService.execute(executeThread);
									}
									boolean loginResult = connectionManager.login();
									if (!loginResult) {
										ZhugePushConfig.echo("service 登录"+"失败");
									}else {
										ZhugePushConfig.echo("service 登录"+"成功");
									}
								}
								if (connectionManager.getLoginStatus()) {
									break;
								}
								Thread.sleep(5000);
							} catch (Exception e) {
								// TODO: handle exception
								e.printStackTrace();
							}
				        	
				        }	
					} catch (Exception e) {
						e.printStackTrace();
					}finally{
						onLogin = false;
					}
					
				}
			}).start();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		return;
	}
	

	public void doLogin(){
		did = getDid();
		ZhugePushConfig.echo("设备id:"+did);
		startLongPolling();
	}
	
	public void handCommand(int cmd, Bundle data){
		try {
			switch (cmd) {
			case ZhugePushConfig.PING:
				boolean status = connectionManager.isOnline();
				ZhugePushConfig.echo(status+":online");
				if (!status) {
					ZhugePushConfig.echo("重新登录");
					onLogin = true;
					doLogin();
				}
				break;
			case ZhugePushConfig.GET_CID:
				if (data == null) {
					return;
				}
				String appId = data.getString("appKey");
				String pkg = data.getString("pkg");
				String clientId = connectionManager.getClientId(appId);
				Intent intent = new Intent(pkg+".recieve");
				intent.putExtra("cid", clientId);
				sendBroadcast(intent);
				break;
			case ZhugePushConfig.MARK:
				if (data == null) {
					return;
				}
				String aid = data.getString("appid");
				String mid = data.getString("mid");
				connectionManager.markMsg(aid, mid);
				break;
			default:
				break;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void onDestroy() {
        try{
            ZhugePushConfig.echo("关啦");
            if (connectionManager != null){
                connectionManager.halt();
            }
            if (executorService != null){
                executorService.shutdownNow();
            }
            ZhugePushConfig.echo("shutdown:"+executorService.isShutdown());
            isStarted=false;
            super.onDestroy();
        }catch (Exception e) {

        }
	}
	
	public synchronized void ensureExecutorService(){
		if (executorService.isShutdown()) {
			executorService = Executors.newFixedThreadPool(2);
		}else {
			executorService.shutdownNow();
			executorService = Executors.newFixedThreadPool(2);
		}
	}
	
}

